/*
 * Decompiled with CFR 0.152.
 */
package cn.imaq.autumn.aop.advice;

import cn.imaq.autumn.aop.exception.AopInvocationException;
import cn.imaq.autumn.core.context.AutumnContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.aspectj.weaver.tools.PointcutExpression;
import org.aspectj.weaver.tools.PointcutParameter;
import org.aspectj.weaver.tools.PointcutParser;
import org.aspectj.weaver.tools.PointcutPrimitive;

public abstract class Advice
implements MethodInterceptor {
    private static final Set<PointcutPrimitive> SUPPORTED_PRIMITIVES = new HashSet<PointcutPrimitive>(){
        {
            this.add(PointcutPrimitive.EXECUTION);
            this.add(PointcutPrimitive.WITHIN);
            this.add(PointcutPrimitive.ARGS);
            this.add(PointcutPrimitive.AT_ANNOTATION);
            this.add(PointcutPrimitive.AT_WITHIN);
            this.add(PointcutPrimitive.AT_ARGS);
            this.add(PointcutPrimitive.REFERENCE);
        }
    };
    private PointcutExpression pointcutExpression;
    private Map<Method, Boolean> methodMatchCache = new ConcurrentHashMap<Method, Boolean>();
    private AutumnContext autumnContext;
    protected Method adviceMethod;
    private boolean isStaticMethod;

    public Advice(AutumnContext autumnContext, String expression, Method adviceMethod) {
        this.autumnContext = autumnContext;
        this.pointcutExpression = PointcutParser.getPointcutParserSupportingSpecifiedPrimitivesAndUsingContextClassloaderForResolution(SUPPORTED_PRIMITIVES).parsePointcutExpression(expression, adviceMethod.getDeclaringClass(), new PointcutParameter[0]);
        this.adviceMethod = adviceMethod;
        this.isStaticMethod = Modifier.isStatic(adviceMethod.getModifiers());
    }

    public boolean matches(Class<?> clazz) {
        return this.pointcutExpression.couldMatchJoinPointsInType(clazz);
    }

    public boolean matches(Method method) {
        return this.methodMatchCache.computeIfAbsent(method, m -> this.pointcutExpression.matchesMethodExecution(m).alwaysMatches());
    }

    public abstract Object invoke(MethodInvocation var1) throws Throwable;

    protected Object invokeAdvice(MethodInvocation invocation) throws Throwable {
        return this.invokeAdvice(invocation, null, -1);
    }

    protected Object invokeAdvice(MethodInvocation invocation, Object extArg, int extArgIndex) throws Throwable {
        Parameter[] params = this.adviceMethod.getParameters();
        Object[] args = new Object[params.length];
        for (int i = 0; i < args.length; ++i) {
            if (i == extArgIndex) {
                args[i] = extArg;
                continue;
            }
            if (!params[i].getType().isAssignableFrom(invocation.getClass())) continue;
            args[i] = invocation;
        }
        try {
            if (this.isStaticMethod) {
                return this.adviceMethod.invoke(null, args);
            }
            Object aspectInstance = this.autumnContext.getBeanByType(this.adviceMethod.getDeclaringClass());
            if (aspectInstance == null) {
                throw new AopInvocationException("Cannot get aspect instance for advice " + this.adviceMethod);
            }
            return this.adviceMethod.invoke(aspectInstance, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }
}

