/*
 * Decompiled with CFR 0.152.
 */
package cn.imaq.autumn.aop.scanner;

import cn.imaq.autumn.aop.AopContext;
import cn.imaq.autumn.aop.HookModel;
import cn.imaq.autumn.aop.annotation.Aspect;
import cn.imaq.autumn.aop.annotation.Hook;
import cn.imaq.autumn.core.beans.BeanInfo;
import cn.imaq.autumn.core.beans.creator.BeanCreator;
import cn.imaq.autumn.core.beans.creator.NormalBeanCreator;
import cn.imaq.autumn.core.beans.scanner.BeanScanner;
import cn.imaq.autumn.core.context.AutumnContext;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AspectBeanScanner
implements BeanScanner {
    private static final Logger log = LoggerFactory.getLogger(AspectBeanScanner.class);

    public void process(ScanSpec spec, AutumnContext context) {
        AopContext aopContext = AopContext.getFrom(context);
        spec.matchClassesWithAnnotation(Aspect.class, cls -> {
            Aspect anno = cls.getAnnotation(Aspect.class);
            String name = anno.value();
            if (name.isEmpty()) {
                name = cls.getSimpleName().toLowerCase();
            }
            context.addBeanInfo(BeanInfo.builder().name(name).type(cls).singleton(true).creator((BeanCreator)new NormalBeanCreator(cls)).build());
            for (Method method : cls.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(Hook.class)) continue;
                method.setAccessible(true);
                Hook hookAnno = method.getAnnotation(Hook.class);
                log.info("Adding hook {}", (Object)hookAnno);
                aopContext.addHook(new HookModel(hookAnno.value(), hookAnno.exclude(), method));
            }
        });
    }
}

