/*
 * Decompiled with CFR 0.152.
 */
package cn.imaq.autumn.aop.processor;

import cn.imaq.autumn.aop.AopContext;
import cn.imaq.autumn.aop.HookModel;
import cn.imaq.autumn.aop.callback.AopMethodInterceptor;
import cn.imaq.autumn.core.beans.BeanWrapper;
import cn.imaq.autumn.core.beans.processor.AfterBeanPopulateProcessor;
import java.util.List;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AopBeanProcessor
implements AfterBeanPopulateProcessor {
    private static final Logger log = LoggerFactory.getLogger(AopBeanProcessor.class);

    public void process(BeanWrapper bean) {
        Class type = bean.getBeanInfo().getType();
        List<HookModel> classHooks = AopContext.getFrom(bean.getContext()).getHooksForClass(type);
        if (!classHooks.isEmpty()) {
            log.info("Creating proxy for {}", (Object)bean.getBeanInstance().getClass().getName());
            Enhancer enhancer = new Enhancer();
            enhancer.setSuperclass(type);
            enhancer.setCallback((Callback)new AopMethodInterceptor(classHooks, bean.getContext(), bean.getBeanInstance()));
            bean.setBeanInstance(enhancer.create());
        }
    }
}

