/*
 * Decompiled with CFR 0.152.
 */
package cn.iisme.zuul;

import java.util.ArrayList;
import java.util.List;
import org.springframework.cloud.netflix.zuul.filters.RouteLocator;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;
import springfox.documentation.swagger.web.SwaggerResource;
import springfox.documentation.swagger.web.SwaggerResourcesProvider;

@Component
@Primary
public class DocumentationConfig
implements SwaggerResourcesProvider {
    private final RouteLocator routeLocator;

    public DocumentationConfig(RouteLocator routeLocator) {
        this.routeLocator = routeLocator;
    }

    public List<SwaggerResource> get() {
        ArrayList<SwaggerResource> resources = new ArrayList<SwaggerResource>();
        List routes = this.routeLocator.getRoutes();
        routes.forEach(route -> resources.add(this.swaggerResource(route.getId(), route.getFullPath().replace("**", "v2/api-docs"), "1.0")));
        return resources;
    }

    private SwaggerResource swaggerResource(String name, String location, String version) {
        SwaggerResource swaggerResource = new SwaggerResource();
        swaggerResource.setName(name);
        swaggerResource.setLocation(location);
        swaggerResource.setSwaggerVersion(version);
        return swaggerResource;
    }
}

