package cn.iisme.starter.redis.common.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.StringRedisSerializer;

import cn.iisme.starter.redis.common.serializer.FastJson2JsonRedisSerializer;

@Configuration
public class RedisConfig {

	protected Logger logger;

	@Lazy(true)
	@Autowired
	private LettuceConnectionFactory redisConnectionFactory;

	public RedisConfig() {
		logger = LoggerFactory.getLogger(getClass());
	}

	@Bean
	public StringRedisSerializer StringRedisSerializer() {
		return new StringRedisSerializer();
	}

	@SuppressWarnings({ "rawtypes", "unchecked" })
	@Bean(name = "redisTemplateForJson")
	public RedisTemplate redisTemplateForJson(StringRedisSerializer stringRedisSerializer) {
		RedisTemplate redisTemplate = new RedisTemplate();
		redisTemplate.setKeySerializer(stringRedisSerializer);
		redisTemplate.setValueSerializer(new FastJson2JsonRedisSerializer<Object>(Object.class));
		redisTemplate.setHashKeySerializer(stringRedisSerializer);
		redisTemplate.setHashValueSerializer(new FastJson2JsonRedisSerializer<Object>(Object.class));
		redisTemplate.setConnectionFactory(redisConnectionFactory);
		return redisTemplate;
	}
	
}