/*
 * Decompiled with CFR 0.152.
 */
package cn.iisme.starter.redis.common.utils;

import cn.iisme.starter.redis.common.IRedisKey;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.TimeoutUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class RedisJsonUtils {
    @Resource(name="redisTemplateForJson")
    private RedisTemplate<String, Object> redisTemplate;
    private static RedisJsonUtils redisJsonUtils;
    private static final long SEVEN_DAYS;

    @PostConstruct
    public void init() {
        redisJsonUtils = this;
        RedisJsonUtils.redisJsonUtils.redisTemplate = this.redisTemplate;
    }

    public static void setExpireTime(String key, long seconds) {
        if (seconds < 1L) {
            seconds = SEVEN_DAYS;
        }
        RedisJsonUtils.redisJsonUtils.redisTemplate.expire((Object)key, seconds, TimeUnit.SECONDS);
    }

    public static void setExpireDate(String key, Date date) {
        if (null == date) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.add(5, 7);
            date = calendar.getTime();
        }
        RedisJsonUtils.redisJsonUtils.redisTemplate.expireAt((Object)key, date);
    }

    public static Boolean exists(String key) {
        return RedisJsonUtils.redisJsonUtils.redisTemplate.hasKey((Object)key);
    }

    public static void remove(String key) {
        RedisJsonUtils.redisJsonUtils.redisTemplate.delete((Object)key);
    }

    public static void remove(List<String> keys) {
        RedisJsonUtils.redisJsonUtils.redisTemplate.delete(keys);
    }

    public static void set(String key, Object value) {
        RedisJsonUtils.redisJsonUtils.redisTemplate.boundValueOps((Object)key).set(value);
    }

    public static void set(String key, Object value, long seconds) {
        Assert.hasText((String)key, (String)"key is not null");
        RedisJsonUtils.redisJsonUtils.redisTemplate.boundValueOps((Object)key).set(value);
        RedisJsonUtils.setExpireTime(key, seconds);
    }

    public static void set(String key, Object value, Date date) {
        Assert.hasText((String)key, (String)"key is not null");
        RedisJsonUtils.redisJsonUtils.redisTemplate.boundValueOps((Object)key).set(value);
        RedisJsonUtils.setExpireDate(key, date);
    }

    public static Object get(String key) {
        return RedisJsonUtils.redisJsonUtils.redisTemplate.boundValueOps((Object)key).get();
    }

    private static Long leftPush(String key, Object value) {
        Assert.hasText((String)key, (String)"key is not null");
        return RedisJsonUtils.redisJsonUtils.redisTemplate.opsForList().leftPush((Object)key, value);
    }

    public static Long leftPush(String key, Object value, long seconds) {
        Long resultLong = RedisJsonUtils.leftPush(key, value);
        RedisJsonUtils.setExpireTime(key, seconds);
        return resultLong;
    }

    private static Long rightPush(String key, Object value) {
        Assert.hasText((String)key, (String)"key is not null");
        return RedisJsonUtils.redisJsonUtils.redisTemplate.opsForList().rightPush((Object)key, value);
    }

    public static Long rightPush(String key, Object value, long seconds) {
        Long resultLong = RedisJsonUtils.rightPush(key, value);
        RedisJsonUtils.setExpireTime(key, seconds);
        return resultLong;
    }

    public static Object leftPop(String key) {
        return RedisJsonUtils.redisJsonUtils.redisTemplate.opsForList().leftPop((Object)key);
    }

    public static Object rightPop(String key) {
        return RedisJsonUtils.redisJsonUtils.redisTemplate.opsForList().rightPop((Object)key);
    }

    public static Long listLength(String key) {
        return RedisJsonUtils.redisJsonUtils.redisTemplate.opsForList().size((Object)key);
    }

    public static List<Object> listRange(String key, int start, int end) {
        return RedisJsonUtils.redisJsonUtils.redisTemplate.opsForList().range((Object)key, (long)start, (long)end);
    }

    public static void listRemove(String key, long i, Object value) {
        RedisJsonUtils.redisJsonUtils.redisTemplate.opsForList().remove((Object)key, i, value);
    }

    public static String index(String key, long index) {
        return (String)RedisJsonUtils.redisJsonUtils.redisTemplate.opsForList().index((Object)key, index);
    }

    public static void listSet(String key, long index, Object value) {
        RedisJsonUtils.redisJsonUtils.redisTemplate.opsForList().set((Object)key, index, value);
    }

    public static void listTrim(String key, long start, int end) {
        RedisJsonUtils.redisJsonUtils.redisTemplate.opsForList().trim((Object)key, start, (long)end);
    }

    public static void setAdd(String key, Object ... values) {
        Assert.hasText((String)key, (String)"key is not null");
        RedisJsonUtils.redisJsonUtils.redisTemplate.opsForSet().add((Object)key, values);
    }

    public static void setAdd(String key, long seconds, Object ... values) {
        RedisJsonUtils.setAdd(key, values);
        RedisJsonUtils.setExpireTime(key, seconds);
    }

    public static Boolean setContains(String key, Object value) {
        return RedisJsonUtils.redisJsonUtils.redisTemplate.opsForSet().isMember((Object)key, value);
    }

    public static long setRemove(String key, Object ... values) {
        return RedisJsonUtils.redisJsonUtils.redisTemplate.opsForSet().remove((Object)key, values);
    }

    public static Set<Object> setMembers(String key) {
        return RedisJsonUtils.redisJsonUtils.redisTemplate.opsForSet().members((Object)key);
    }

    public static void hashPut(String key, String hkey, Object hvalue) {
        Assert.hasText((String)key, (String)"key is not null");
        Assert.hasText((String)key, (String)"hkey is not null");
        RedisJsonUtils.redisJsonUtils.redisTemplate.opsForHash().put((Object)key, (Object)hkey, hvalue);
    }

    public static void hashPut(String key, String hkey, Object hvalue, long seconds) {
        RedisJsonUtils.hashPut(key, hkey, hvalue);
        RedisJsonUtils.setExpireTime(key, seconds);
    }

    public static Object hashGet(String key, String hkey) {
        Assert.hasText((String)key, (String)"key is not null");
        Assert.hasText((String)key, (String)"hkey is not null");
        return RedisJsonUtils.redisJsonUtils.redisTemplate.opsForHash().get((Object)key, (Object)hkey);
    }

    public static long hashRemove(String key, Object ... hkey) {
        Assert.hasText((String)key, (String)"key is not null");
        return RedisJsonUtils.redisJsonUtils.redisTemplate.opsForHash().delete((Object)key, hkey);
    }

    public static Map<String, Object> hashEntries(String key) {
        Assert.hasText((String)key, (String)"key is not null");
        BoundHashOperations ops = RedisJsonUtils.redisJsonUtils.redisTemplate.boundHashOps((Object)key);
        return ops.entries();
    }

    public static Set<String> hashKeys(String key) {
        return RedisJsonUtils.redisJsonUtils.redisTemplate.opsForHash().keys((Object)key);
    }

    public static Boolean hashHasKey(String key, String hashKey) {
        return RedisJsonUtils.redisJsonUtils.redisTemplate.opsForHash().hasKey((Object)key, (Object)hashKey);
    }

    public static Long hashSize(String key) {
        return RedisJsonUtils.redisJsonUtils.redisTemplate.opsForHash().size((Object)key);
    }

    public static void hashPutAll(String key, Map<String, Object> m) {
        RedisJsonUtils.redisJsonUtils.redisTemplate.opsForHash().putAll((Object)key, m);
    }

    public static long getExpire(String key) {
        return RedisJsonUtils.redisJsonUtils.redisTemplate.getExpire((Object)key);
    }

    public static Set<String> getKeys(String pattern) {
        return RedisJsonUtils.redisJsonUtils.redisTemplate.keys((Object)pattern);
    }

    public static long increment(String key) {
        return RedisJsonUtils.redisJsonUtils.redisTemplate.boundValueOps((Object)key).increment(1L);
    }

    public static <T> T queryWithCache(IRedisKey redisKey, Supplier<T> supplier) {
        return RedisJsonUtils.queryWithCache(redisKey, redisKey.getExpireSeconds().intValue(), supplier);
    }

    public static <T> T queryWithCache(IRedisKey redisKey, long seconds, Supplier<T> supplier) {
        Object obj = RedisJsonUtils.get(redisKey.getKey());
        if (obj == null) {
            obj = supplier.get();
            RedisJsonUtils.set(redisKey.getKey(), obj, seconds);
        }
        return (T)obj;
    }

    static {
        SEVEN_DAYS = TimeoutUtils.toSeconds((long)7L, (TimeUnit)TimeUnit.DAYS);
    }
}

