/*
 * Decompiled with CFR 0.152.
 */
package cn.iisme.starter.redis.common.lock;

import java.util.Collections;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.script.DigestUtils;
import org.springframework.data.redis.core.script.RedisScript;

public class RedisLock {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisLock.class);
    private final StringRedisTemplate stringRedisTemplate;
    private final String lockKey;
    private final String lockValue;
    private boolean locked = false;
    private static final RedisScript<Boolean> SETNX_AND_EXPIRE_SCRIPT;
    private static final RedisScript<Boolean> DEL_IF_GET_EQUALS;

    public RedisLock(StringRedisTemplate stringRedisTemplate, String lockKey) {
        this.stringRedisTemplate = stringRedisTemplate;
        this.lockKey = lockKey;
        this.lockValue = UUID.randomUUID().toString() + "." + System.currentTimeMillis();
    }

    private boolean doTryLock(int lockSeconds) throws Exception {
        if (this.locked) {
            throw new IllegalStateException("already locked!");
        }
        this.locked = (Boolean)this.stringRedisTemplate.execute(SETNX_AND_EXPIRE_SCRIPT, Collections.singletonList(this.lockKey), new Object[]{this.lockValue, String.valueOf(lockSeconds)});
        return this.locked;
    }

    public boolean tryLock(int lockSeconds) {
        try {
            return this.doTryLock(lockSeconds);
        }
        catch (Exception e) {
            LOGGER.error("tryLock Error", (Throwable)e);
            return false;
        }
    }

    public boolean tryLock(int lockSeconds, long tryIntervalMillis, int maxTryCount) {
        int tryCount = 0;
        while (++tryCount < maxTryCount) {
            try {
                if (this.doTryLock(lockSeconds)) {
                    return true;
                }
            }
            catch (Exception e) {
                LOGGER.error("tryLock Error", (Throwable)e);
                break;
            }
            try {
                Thread.sleep(tryIntervalMillis);
            }
            catch (InterruptedException e) {
                LOGGER.error("tryLock interrupted", (Throwable)e);
                break;
            }
        }
        return false;
    }

    public void unlock() {
        if (!this.locked) {
            throw new IllegalStateException("not locked yet!");
        }
        this.locked = false;
        this.stringRedisTemplate.execute(DEL_IF_GET_EQUALS, Collections.singletonList(this.lockKey), new Object[]{this.lockValue});
    }

    static {
        StringBuilder sb = new StringBuilder();
        sb.append("if (redis.call('setnx', KEYS[1], ARGV[1]) == 1) then\n");
        sb.append("\tredis.call('expire', KEYS[1], tonumber(ARGV[2]))\n");
        sb.append("\treturn true\n");
        sb.append("else\n");
        sb.append("\treturn false\n");
        sb.append("end");
        SETNX_AND_EXPIRE_SCRIPT = new RedisScriptImpl<Boolean>(sb.toString(), Boolean.class);
        sb = new StringBuilder();
        sb.append("if (redis.call('get', KEYS[1]) == ARGV[1]) then\n");
        sb.append("\tredis.call('del', KEYS[1])\n");
        sb.append("\treturn true\n");
        sb.append("else\n");
        sb.append("\treturn false\n");
        sb.append("end");
        DEL_IF_GET_EQUALS = new RedisScriptImpl<Boolean>(sb.toString(), Boolean.class);
    }

    private static class RedisScriptImpl<T>
    implements RedisScript<T> {
        private final String script;
        private final String sha1;
        private final Class<T> resultType;

        RedisScriptImpl(String script, Class<T> resultType) {
            this.script = script;
            this.sha1 = DigestUtils.sha1DigestAsHex((String)script);
            this.resultType = resultType;
        }

        public String getSha1() {
            return this.sha1;
        }

        public Class<T> getResultType() {
            return this.resultType;
        }

        public String getScriptAsString() {
            return this.script;
        }
    }
}

