/*
 * Decompiled with CFR 0.152.
 */
package cn.iisme.starter.redis.common.config;

import cn.iisme.starter.redis.common.serializer.FastJson2JsonRedisSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@Configuration
public class RedisConfig {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Lazy(value=true)
    @Autowired
    private LettuceConnectionFactory redisConnectionFactory;

    @Bean
    public StringRedisSerializer StringRedisSerializer() {
        return new StringRedisSerializer();
    }

    @Bean(name={"redisTemplateForJson"})
    public RedisTemplate redisTemplateForJson(StringRedisSerializer stringRedisSerializer) {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setKeySerializer((RedisSerializer)stringRedisSerializer);
        redisTemplate.setValueSerializer(new FastJson2JsonRedisSerializer<Object>(Object.class));
        redisTemplate.setHashKeySerializer((RedisSerializer)stringRedisSerializer);
        redisTemplate.setHashValueSerializer(new FastJson2JsonRedisSerializer<Object>(Object.class));
        redisTemplate.setConnectionFactory((RedisConnectionFactory)this.redisConnectionFactory);
        return redisTemplate;
    }
}

