/*
 * Decompiled with CFR 0.152.
 */
package cn.iisme.starter.redis.common;

import cn.iisme.starter.redis.common.IRedisKey;
import org.slf4j.helpers.MessageFormatter;

public class RedisKey
implements IRedisKey {
    private static final Integer HOUR = 3600;
    private String key;
    private Integer expireSeconds;

    public RedisKey() {
    }

    public RedisKey(String key, Integer expireSeconds) {
        this.key = key;
        this.expireSeconds = expireSeconds;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public Integer getExpireSeconds() {
        return this.expireSeconds;
    }

    public void setExpireSeconds(Integer expireSeconds) {
        this.expireSeconds = expireSeconds;
    }

    public static RedisKey init(String key) {
        return new RedisKey(key, HOUR);
    }

    public static RedisKey init(String key, Integer expireSeconds) {
        return new RedisKey(key, expireSeconds);
    }

    public RedisKey fill(Object ... args) {
        String newKey = MessageFormatter.arrayFormat((String)this.key, (Object[])args).getMessage();
        return new RedisKey(newKey, this.getExpireSeconds());
    }
}

