package cn.iisme.starter.redis.common;

import org.slf4j.helpers.MessageFormatter;

public class RedisKey implements IRedisKey {

	/** 一小时 */
	private static final Integer HOUR = 3600;
	
	/** 缓存KEY值 */
	private String key;

	/** 过期时间(秒) */
	private Integer expireSeconds;

	public RedisKey() {
		super();
	}

	public RedisKey(String key, Integer expireSeconds) {
		this.key = key;
		this.expireSeconds = expireSeconds;
	}

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public Integer getExpireSeconds() {
		return expireSeconds;
	}

	public void setExpireSeconds(Integer expireSeconds) {
		this.expireSeconds = expireSeconds;
	}

	public static RedisKey init(String key) {
		return new RedisKey(key, HOUR);
	}

	public static RedisKey init(String key, Integer expireSeconds) {
		return new RedisKey(key, expireSeconds);
	}
	
	public RedisKey fill(Object... args) {
		String newKey = MessageFormatter.arrayFormat(this.key, args).getMessage();
		return new RedisKey(newKey, this.getExpireSeconds());
	}
}