/*
 * Decompiled with CFR 0.152.
 */
package cn.idea360.unified.response;

import cn.idea360.unified.annotation.UnifiedIgnore;
import cn.idea360.unified.configuration.UnifiedProperties;
import cn.idea360.unified.exception.BizException;
import cn.idea360.unified.response.UnifiedResult;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@EnableConfigurationProperties(value={UnifiedProperties.class})
@ConditionalOnProperty(value={"idea360.framework.unified.enable"}, havingValue="true", matchIfMissing=true)
@RestControllerAdvice
public class UnifiedResponseBodyAdvice
implements ResponseBodyAdvice<Object>,
BeanFactoryAware {
    private static final List<String> INNER_IGNORES = Arrays.asList("/swagger-ui.html", "/swagger-ui/**", "/swagger-resources/**", "/v2/api-docs", "/v3/api-docs", "/webjars/**", "/doc**", "/version", "/actuator/**", "/favicon.ico");
    private ObjectMapper objectMapper;
    @Resource
    private UnifiedProperties unifiedProperties;
    private static final AntPathMatcher ANT_PATH_MATCHER = new AntPathMatcher();

    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        return !returnType.getGenericParameterType().equals(UnifiedResult.class) && !returnType.hasMethodAnnotation(UnifiedIgnore.class);
    }

    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        String servletPath = ((ServletServerHttpRequest)request).getServletRequest().getServletPath();
        if (this.ignoring(servletPath)) {
            return body;
        }
        if (returnType.getGenericParameterType().equals(String.class) || body instanceof String) {
            try {
                response.getHeaders().set("Content-Type", "application/json;charset=utf-8");
                return this.objectMapper.writeValueAsString(new UnifiedResult.Builder<Object>().data(body).build());
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
                throw new BizException("\u8fd4\u56deString\u7c7b\u578b\u9519\u8bef");
            }
        }
        return new UnifiedResult.Builder<Object>().data(body).build();
    }

    private boolean ignoring(String uri) {
        return this.contains(INNER_IGNORES, uri) || this.contains(this.unifiedProperties.getIgnores(), uri);
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.objectMapper = (ObjectMapper)beanFactory.getBean(ObjectMapper.class);
    }

    protected boolean contains(List<String> paths, String servletPath) {
        if (Objects.nonNull(paths) && !paths.isEmpty()) {
            for (String path : paths) {
                String uriPattern = path.trim();
                if (!ANT_PATH_MATCHER.match(uriPattern, servletPath)) continue;
                return true;
            }
        }
        return false;
    }
}

