/*
 * Decompiled with CFR 0.152.
 */
package cn.idea360.unified.request;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Valid;
import javax.validation.Validation;
import javax.validation.Validator;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.RequestBodyAdvice;

@ConditionalOnProperty(value={"idea360.framework.unified.enable"}, havingValue="true", matchIfMissing=true)
@RestControllerAdvice
public class ValidateRequestBodyAdvice
implements RequestBodyAdvice {
    private static final Validator VALIDATOR = ((HibernateValidatorConfiguration)((HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure()).failFast(true)).buildValidatorFactory().getValidator();

    public boolean supports(MethodParameter methodParameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        boolean matchValidAnnotation = Arrays.stream(methodParameter.getMethodAnnotations()).anyMatch(t -> t.annotationType().equals(Validated.class) || t.annotationType().equals(Valid.class));
        boolean matchString = methodParameter.getParameterType().isAssignableFrom(String.class);
        boolean matchPostOrPutMapping = Arrays.stream(methodParameter.getMethodAnnotations()).anyMatch(t -> t.annotationType().equals(PostMapping.class) || t.annotationType().equals(PutMapping.class));
        boolean matchPostOrPutRequestMapping = Arrays.stream(methodParameter.getMethodAnnotations()).anyMatch(t -> t.annotationType().equals(RequestMapping.class) && Arrays.stream(((RequestMapping)AnnotationUtils.getAnnotation((Annotation)t, RequestMapping.class)).method()).anyMatch(m -> m.equals((Object)RequestMethod.POST) || m.equals((Object)RequestMethod.PUT)));
        return (matchPostOrPutMapping || matchPostOrPutRequestMapping) && !matchValidAnnotation && !matchString;
    }

    public HttpInputMessage beforeBodyRead(HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) throws IOException {
        return inputMessage;
    }

    public Object afterBodyRead(Object body, HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        Set constraintViolations = VALIDATOR.validate(body, new Class[0]);
        if (!constraintViolations.isEmpty()) {
            throw new ConstraintViolationException(constraintViolations);
        }
        return body;
    }

    public Object handleEmptyBody(Object body, HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return body;
    }
}

