/*
 * Decompiled with CFR 0.152.
 */
package cn.idea360.unified.exception;

import cn.idea360.unified.exception.BizException;
import cn.idea360.unified.response.UnifiedResult;
import java.util.Objects;
import javax.validation.ConstraintViolationException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.converter.HttpMessageConversionException;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class UnifiedExceptionHandler {
    private final Logger log = LoggerFactory.getLogger(UnifiedExceptionHandler.class);

    @ExceptionHandler(value={BindException.class})
    public UnifiedResult<?> exceptionHandler(BindException e) {
        this.log.error("\u53c2\u6570\u7ed1\u5b9a\u5f02\u5e38", (Throwable)e);
        BindingResult bindingResult = e.getBindingResult();
        return new UnifiedResult.Builder().error(-1, Objects.requireNonNull(bindingResult.getFieldError()).getDefaultMessage()).build();
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public UnifiedResult<?> exceptionHandler(MethodArgumentNotValidException e) {
        this.log.error("\u53c2\u6570\u6821\u9a8c\u5f02\u5e38", (Throwable)e);
        BindingResult bindingResult = e.getBindingResult();
        return new UnifiedResult.Builder().error(-1, Objects.requireNonNull(bindingResult.getFieldError()).getDefaultMessage()).build();
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    public UnifiedResult<?> handler(ConstraintViolationException e) {
        this.log.error("\u53c2\u6570\u9a8c\u8bc1\u5f02\u5e38", (Throwable)e);
        return new UnifiedResult.Builder().error(-1, e.getMessage()).build();
    }

    @ExceptionHandler(value={HttpMessageConversionException.class})
    public UnifiedResult<?> handler(HttpMessageConversionException e) {
        this.log.error("\u53c2\u6570\u7c7b\u578b\u8f6c\u6362\u9519\u8bef", (Throwable)e);
        return new UnifiedResult.Builder().error(-1, e.getMessage()).build();
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public UnifiedResult<?> handler(HttpMessageNotReadableException e) {
        this.log.error("\u53c2\u6570\u683c\u5f0f\u5f02\u5e38", (Throwable)e);
        return new UnifiedResult.Builder().error(-1, e.getMessage()).build();
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public UnifiedResult<?> handler(HttpRequestMethodNotSupportedException e) {
        this.log.error("\u8bf7\u6c42\u65b9\u5f0f\u5f02\u5e38", (Throwable)e);
        return new UnifiedResult.Builder().error(-1, "\u8bf7\u6c42\u65b9\u5f0f\u9519\u8bef").build();
    }

    @ExceptionHandler(value={HttpMediaTypeNotSupportedException.class})
    public UnifiedResult<?> handler(HttpMediaTypeNotSupportedException e) {
        this.log.error("\u5a92\u4f53\u7c7b\u578b\u5f02\u5e38", (Throwable)e);
        return new UnifiedResult.Builder().error(-1, "\u5a92\u4f53\u7c7b\u578b\u9519\u8bef").build();
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    public UnifiedResult<?> handler(MissingServletRequestParameterException e) {
        this.log.error("\u8bf7\u6c42\u53c2\u6570\u4e22\u5931", (Throwable)e);
        return new UnifiedResult.Builder().error(-1, e.getMessage()).build();
    }

    @ExceptionHandler(value={BizException.class})
    public UnifiedResult<?> exceptionHandler(BizException e) {
        this.log.error("\u4e1a\u52a1\u5f02\u5e38", (Throwable)e);
        return new UnifiedResult.Builder().error(e.getCode(), e.getMessage()).build();
    }

    @ExceptionHandler(value={Throwable.class})
    public UnifiedResult<?> exceptionHandler(Throwable e) {
        this.log.error("\u515c\u5e95\u5f02\u5e38: {}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
        String message = e.getMessage();
        if (message.contains("RpcException")) {
            message = "dubbo\u670d\u52a1\u5f02\u5e38";
        }
        return new UnifiedResult.Builder().error(-1, message).build();
    }
}

