/*
 * Decompiled with CFR 0.152.
 */
package cn.icframework.mybatis.processor.gen.java;

import cn.icframework.mybatis.processor.gen.FileUtils;
import cn.icframework.mybatis.processor.gen.GenUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.tools.JavaFileObject;
import org.apache.commons.lang3.StringUtils;

public class DefGenerator {
    private static final String separator = "/";

    public static void genFile(Filer filer, String genFilePath, String packageName, String modelName, String modelNameFistUp, String modelNameFistDown, String date, String content, Element ... elements) {
        Writer writer = null;
        try {
            JavaFileObject sourceFile = filer.createSourceFile(packageName.replace(separator, ".") + ".def." + modelName + "Def", elements);
            if (genFilePath == null || genFilePath.isEmpty()) {
                writer = new OutputStreamWriter(sourceFile.openOutputStream(), StandardCharsets.UTF_8);
                writer.write(DefGenerator.buildContent(packageName, modelName, modelNameFistUp, modelNameFistDown, date, content));
                writer.flush();
                return;
            }
            String defaultGenPath = sourceFile.toUri().getPath();
            genFilePath = genFilePath.replace("\\", separator);
            defaultGenPath = defaultGenPath.replace("\\", separator);
            if (genFilePath.endsWith(separator)) {
                genFilePath = genFilePath.substring(0, genFilePath.length() - 1);
            }
            Object javaPath = FileUtils.isAbsolutePath(genFilePath) ? DefGenerator.getJavaPath(genFilePath, packageName, defaultGenPath) : (StringUtils.isNotEmpty((CharSequence)genFilePath) ? genFilePath + separator + packageName.replace(".", separator) + ".def" : defaultGenPath.substring(0, defaultGenPath.lastIndexOf(separator)));
            File defFile = new File((String)javaPath + separator + modelName + "Def.java");
            String buildContent = DefGenerator.buildContent(packageName, modelName, modelNameFistUp, modelNameFistDown, date, content);
            FileUtils.writerFile(defFile, buildContent);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static String getJavaPath(String genFilePath, String packageName, String defaultGenPath) {
        return defaultGenPath.substring(0, defaultGenPath.indexOf("/target/generated-sources/")) + "/src" + genFilePath + separator + packageName.replace(".", separator) + "/def";
    }

    private static String buildContent(String packageName, String modelName, String modelNameFistUp, String modelNameFistDown, String date, String content) {
        String luCaseToCharSplit = GenUtils.luCaseToCharSplit(modelName, "-");
        return "package #PACKAGE_NAME.def;\n\nimport #PACKAGE_NAME.#MODEL_NAME_FIST_UP;\nimport cn.icframework.mybatis.query.QueryTable;\nimport cn.icframework.mybatis.query.QueryField;\n\n/**\n * \u8bf7\u52ff\u4fee\u6539\u8be5\u6587\u4ef6\uff0c\u8be5\u6587\u4ef6\u7531ic mybatis\u751f\u6210\u4f1a\u88ab\u8986\u76d6\n * @author #AUTHOR\n * @since #DATE\n */\npublic class #MODEL_NAME_FIST_UPDef extends QueryTable<#MODEL_NAME_FIST_UPDef> {\n\n    public #MODEL_NAME_FIST_UPDef(Class<?> defClass) {\n        super(defClass);\n    }\n\n    public static #MODEL_NAME_FIST_UPDef table() {\n        return new #MODEL_NAME_FIST_UPDef(#MODEL_NAME_FIST_UP.class);\n    }\n\n    @Override\n    public #MODEL_NAME_FIST_UPDef newInstance() {\n        return new #MODEL_NAME_FIST_UPDef(#MODEL_NAME_FIST_UPDef.class);\n    }\n\n    public QueryField<#MODEL_NAME_FIST_UPDef> _all= new QueryField<>(this, \"*\");\n\n#CONTENT\n}\n".replaceAll("#PACKAGE_NAME", packageName).replaceAll("#MODEL_NAME_FIST_UP", modelNameFistUp).replaceAll("#MODEL_NAME_FIST_DOWN", modelNameFistDown).replaceAll("#AUTHOR", "ic generator").replaceAll("#CONTENT", content).replaceAll("#LU_CASE_TO_CHAR_SPLIT", luCaseToCharSplit).replaceAll("#DATE", date);
    }
}

