/*
 * Decompiled with CFR 0.152.
 */
package cn.icframework.mybatis.processor;

import cn.icframework.mybatis.annotation.Id;
import cn.icframework.mybatis.annotation.Table;
import cn.icframework.mybatis.annotation.TableField;
import cn.icframework.mybatis.processor.Generator;
import cn.icframework.mybatis.processor.Props;
import cn.icframework.mybatis.processor.gen.java.DefGenerator;
import cn.icframework.mybatis.utils.ModelClassUtils;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

public class TableProcessor
extends AbstractProcessor {
    private static final String CONFIG_KEY_GEN_PATH = "processor.gen-path";
    private static final String DEFAULT_GEN_PATH = "";
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy/MM/dd");
    private static final String COLOR_BLUE = "\u001b[0;34m";
    private static final String COLOR_GREEN = "\u001b[0;32m";
    private static final String COLOR_RED = "\u001b[0;31m";
    private static final String COLOR_RESET = "\u001b[0;29m";
    private Props props;
    private Filer filer;
    private Types typeUtils;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.filer = processingEnv.getFiler();
        this.typeUtils = processingEnv.getTypeUtils();
        this.props = new Props(this.filer);
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> supportedAnnotationTypes = new HashSet<String>();
        supportedAnnotationTypes.add(Table.class.getCanonicalName());
        return supportedAnnotationTypes;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            return false;
        }
        try {
            String javaGenPath = this.getGenPath();
            for (Element element : roundEnv.getElementsAnnotatedWith(Table.class)) {
                this.processEntityClass(element, javaGenPath);
            }
        }
        catch (Exception e) {
            this.logError("\u5904\u7406\u6ce8\u89e3\u65f6\u53d1\u751f\u9519\u8bef: " + e.getMessage(), e);
        }
        return false;
    }

    private String getGenPath() {
        return this.props.getProperties().getProperty(CONFIG_KEY_GEN_PATH, DEFAULT_GEN_PATH);
    }

    private void processEntityClass(Element entityClassElement, String javaGenPath) {
        if (entityClassElement.getKind() != ElementKind.CLASS) {
            return;
        }
        if (!this.shouldGenerate(entityClassElement)) {
            return;
        }
        ClassInfo classInfo = this.parseClassInfo(entityClassElement);
        String defContent = this.parseFields(entityClassElement, classInfo);
        this.generateDefClass(entityClassElement, classInfo, defContent, javaGenPath);
        this.logSuccess("ic mybatis gen :: " + String.valueOf(entityClassElement));
    }

    private boolean shouldGenerate(Element entityClassElement) {
        Generator generator = entityClassElement.getAnnotation(Generator.class);
        return generator == null || generator.gen();
    }

    private ClassInfo parseClassInfo(Element entityClassElement) {
        String fullClassName = entityClassElement.toString();
        String packageName = fullClassName.substring(0, fullClassName.lastIndexOf("."));
        String modelName = entityClassElement.getSimpleName().toString();
        String firstChar = modelName.substring(0, 1);
        String remainingChars = modelName.substring(1);
        String modelNameFirstUp = firstChar.toUpperCase() + remainingChars;
        String modelNameFirstDown = firstChar.toLowerCase() + remainingChars;
        String currentDate = DATE_FORMATTER.format(LocalDateTime.now());
        return new ClassInfo(packageName, modelName, modelNameFirstUp, modelNameFirstDown, currentDate);
    }

    private String parseFields(Element entityClassElement, ClassInfo classInfo) {
        TypeMirror superclass;
        StringBuilder defContentBuilder = new StringBuilder();
        HashSet<String> processedFields = new HashSet<String>();
        TypeElement classElement = (TypeElement)entityClassElement;
        do {
            Table table = classElement.getAnnotation(Table.class);
            for (Element element : classElement.getEnclosedElements()) {
                if (element.getKind() != ElementKind.FIELD) continue;
                this.processField(table, element, classInfo, defContentBuilder, processedFields);
            }
        } while (!Objects.equals((superclass = classElement.getSuperclass()).toString(), Object.class.getName()) && (classElement = (TypeElement)this.typeUtils.asElement(superclass)) != null);
        return defContentBuilder.toString();
    }

    private void processField(Table table, Element fieldElement, ClassInfo classInfo, StringBuilder defContentBuilder, Set<String> processedFields) {
        Set<Modifier> modifiers = fieldElement.getModifiers();
        if (modifiers.contains((Object)Modifier.STATIC)) {
            return;
        }
        String fieldName = fieldElement.getSimpleName().toString();
        if (processedFields.contains(fieldName)) {
            return;
        }
        TableField tableField = fieldElement.getAnnotation(TableField.class);
        Id id = fieldElement.getAnnotation(Id.class);
        if (id == null && tableField == null) {
            return;
        }
        processedFields.add(fieldName);
        String columnName = ModelClassUtils.getColumnName((Table)table, (TableField)tableField, (String)fieldName);
        String fieldDefinition = String.format("    public QueryField<%sDef> %s = new QueryField<>(this, \"%s\");\n", classInfo.modelNameFirstUp(), fieldName, columnName);
        defContentBuilder.append(fieldDefinition);
    }

    private void generateDefClass(Element entityClassElement, ClassInfo classInfo, String defContent, String javaGenPath) {
        DefGenerator.genFile(this.filer, javaGenPath, classInfo.packageName(), classInfo.modelName(), classInfo.modelNameFirstUp(), classInfo.modelNameFirstDown(), classInfo.currentDate(), defContent, entityClassElement);
    }

    private void logSuccess(String message) {
        System.out.printf("%-1s", "[");
        System.out.format(COLOR_BLUE, new Object[0]);
        System.out.printf("%-4s", "INFO");
        System.out.format(COLOR_RESET, new Object[0]);
        System.out.printf("%-2s", "]");
        System.out.printf("%-26s", "--- " + message);
        System.out.format(COLOR_GREEN, new Object[0]);
        System.out.printf("%-7s", "\tSUCCESS");
        System.out.format(COLOR_RESET, new Object[0]);
        System.out.println();
    }

    private void logError(String message, Throwable throwable) {
        System.out.printf("%-1s", "[");
        System.out.format(COLOR_RED, new Object[0]);
        System.out.printf("%-4s", "ERROR");
        System.out.format(COLOR_RESET, new Object[0]);
        System.out.printf("%-2s", "]");
        System.out.printf("%-26s", "--- " + message);
        System.out.println();
        if (throwable != null) {
            throwable.printStackTrace();
        }
    }

    private record ClassInfo(String packageName, String modelName, String modelNameFirstUp, String modelNameFirstDown, String currentDate) {
    }
}

