/*
 * Decompiled with CFR 0.152.
 */
package cn.icframework.mybatis.processor;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Properties;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

class Props {
    private static final String DEFAULT_ENCODING = StandardCharsets.UTF_8.name();
    private static final String CONFIG_FILE_NAME = "ic-mybatis.properties";
    private final Properties properties = new Properties();

    public Props(Filer filer) {
        this.loadProperties(filer);
    }

    private void loadProperties(Filer filer) {
        try (InputStream inputStream = this.findPropertiesInputStream(filer);){
            if (inputStream != null) {
                this.properties.load(new InputStreamReader(inputStream, DEFAULT_ENCODING));
            }
        }
        catch (IOException e) {
            System.err.println("Failed to load properties file: " + e.getMessage());
        }
    }

    private InputStream findPropertiesInputStream(Filer filer) throws IOException {
        InputStream inputStream = this.loadFromClassOutput(filer);
        if (inputStream != null) {
            return inputStream;
        }
        inputStream = this.loadFromClasspath();
        if (inputStream != null) {
            return inputStream;
        }
        return this.loadFromProjectResources(filer);
    }

    private InputStream loadFromClassOutput(Filer filer) throws IOException {
        try {
            FileObject propertiesFileObject = filer.getResource(StandardLocation.CLASS_OUTPUT, "", CONFIG_FILE_NAME);
            File propertiesFile = new File(propertiesFileObject.toUri());
            if (propertiesFile.exists()) {
                return propertiesFileObject.openInputStream();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private InputStream loadFromClasspath() {
        return this.getClass().getClassLoader().getResourceAsStream(CONFIG_FILE_NAME);
    }

    private InputStream loadFromProjectResources(Filer filer) throws IOException {
        try {
            File projectPropertiesFile;
            FileObject propertiesFileObject = filer.getResource(StandardLocation.CLASS_OUTPUT, "", CONFIG_FILE_NAME);
            File propertiesFile = new File(propertiesFileObject.toUri());
            File pomXmlFile = this.findPomXmlFile(propertiesFile);
            if (pomXmlFile != null && pomXmlFile.exists() && (projectPropertiesFile = new File(pomXmlFile.getParentFile(), "src/main/resources/ic-mybatis.properties")).exists()) {
                return Files.newInputStream(projectPropertiesFile.toPath(), new OpenOption[0]);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private File findPomXmlFile(File propertiesFile) {
        if (propertiesFile == null || !propertiesFile.exists()) {
            return null;
        }
        File parent = propertiesFile.getParentFile();
        if (parent == null) {
            return null;
        }
        for (int i = 0; i < 3 && (parent = parent.getParentFile()) != null; ++i) {
            File pomXmlFile = new File(parent, "pom.xml");
            if (!pomXmlFile.exists()) continue;
            return pomXmlFile;
        }
        return null;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        return this.properties.getProperty(key, defaultValue);
    }

    public boolean containsKey(String key) {
        return this.properties.containsKey(key);
    }

    public Set<String> stringPropertyNames() {
        return this.properties.stringPropertyNames();
    }
}

