/*
 * Decompiled with CFR 0.152.
 */
package cn.icanci.loopstack.rec.engine.script.impl;

import cn.hutool.http.Method;
import cn.hutool.json.JSONUtil;
import cn.icanci.loopstack.rec.common.enums.HttpRequestTypeEnum;
import cn.icanci.loopstack.rec.common.enums.ScriptTypeEnum;
import cn.icanci.loopstack.rec.engine.script.RecScriptEngine;
import cn.icanci.loopstack.rec.engine.script.client.Client;
import cn.icanci.loopstack.rec.engine.script.client.http.HttpClientImpl;
import cn.icanci.loopstack.rec.engine.script.context.RecScriptEngineContext;
import cn.icanci.loopstack.rec.engine.script.factory.ScriptEngineFactory;
import cn.icanci.loopstack.rec.engine.script.wrapper.HttpResponseWrapper;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.SimpleBindings;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecScriptEngineImpl
implements RecScriptEngine {
    private static final Logger logger = LoggerFactory.getLogger(RecScriptEngineImpl.class);
    private static final Client CLIENT = HttpClientImpl.getInstance();

    @Override
    public ScriptEngine findEngine(ScriptTypeEnum scriptType) {
        return ScriptEngineFactory.getScriptEngine(scriptType);
    }

    @Override
    public CompiledScript compile(ScriptTypeEnum scriptType, String scriptContent) {
        try {
            ScriptEngine scriptEngine = ScriptEngineFactory.getScriptEngine(scriptType);
            if (scriptEngine instanceof Compilable) {
                Compilable compilable = (Compilable)((Object)scriptEngine);
                return compilable.compile(scriptContent);
            }
        }
        catch (Throwable t) {
            logger.error("[RecScriptEngine][compile] compile error:{}", (Object)t.getMessage());
        }
        return null;
    }

    @Override
    public RecScriptEngineContext<Object> eval(ScriptTypeEnum scriptType, String script) {
        return this.eval(scriptType, new SimpleBindings(), script);
    }

    @Override
    public RecScriptEngineContext<Object> eval(ScriptTypeEnum scriptType, Bindings bindings, String script) {
        RecScriptEngineContext<Object> context = new RecScriptEngineContext<Object>();
        context.setScriptType(scriptType);
        context.setScriptContent(script);
        context.setType(Object.class);
        context.setBindings(bindings);
        try {
            ScriptEngine scriptEngine = ScriptEngineFactory.getScriptEngine(scriptType);
            context.setScriptEngine(scriptEngine);
            if (scriptEngine instanceof Compilable) {
                Compilable compilable = (Compilable)((Object)scriptEngine);
                context.setCompilable(compilable);
                CompiledScript compile = compilable.compile(script);
                context.setCompiledScript(compile);
                Object eval = compile.eval(bindings);
                context.setRetVal(eval);
            } else {
                Object eval = scriptEngine.eval(script, bindings);
                context.setRetVal(eval);
            }
        }
        catch (Throwable t) {
            context.setThrowable(t);
        }
        return context;
    }

    @Override
    public <T> RecScriptEngineContext<T> eval(ScriptTypeEnum scriptType, String script, Class<T> clazz) {
        return this.eval(scriptType, new SimpleBindings(), script, clazz);
    }

    @Override
    public <T> RecScriptEngineContext<T> eval(ScriptTypeEnum scriptType, Bindings bindings, String script, Class<T> clazz) {
        RecScriptEngineContext<Object> context = new RecScriptEngineContext<Object>();
        context.setScriptType(scriptType);
        context.setScriptContent(script);
        context.setType(clazz);
        context.setBindings(bindings);
        try {
            ScriptEngine scriptEngine = ScriptEngineFactory.getScriptEngine(scriptType);
            context.setScriptEngine(scriptEngine);
            if (scriptEngine instanceof Compilable) {
                Compilable compilable = (Compilable)((Object)scriptEngine);
                context.setCompilable(compilable);
                CompiledScript compile = compilable.compile(script);
                context.setCompiledScript(compile);
                Object eval = compile.eval(bindings);
                context.setRetVal(eval);
            } else {
                Object eval = scriptEngine.eval(script, bindings);
                context.setRetVal(eval);
            }
        }
        catch (Throwable t) {
            context.setThrowable(t);
        }
        return context;
    }

    @Override
    public HttpResponseWrapper httpEval(HttpRequestTypeEnum requestType, String reqUrl, String reqParam, int timeout) {
        Method method = null;
        switch (requestType) {
            case GET: {
                method = Method.GET;
                break;
            }
            case POST: {
                method = Method.POST;
                break;
            }
        }
        if (method == null) {
            throw new NullPointerException("HttpMethod is Null !");
        }
        if (timeout <= 0) {
            throw new IllegalArgumentException("Http Request Timeout is Less than 0!");
        }
        HashMap headers = Maps.newHashMap();
        Map reqMap = Maps.newHashMap();
        if (StringUtils.isNotBlank((CharSequence)reqParam)) {
            reqMap = (Map)JSONUtil.toBean((String)reqParam, Map.class);
        }
        Client.RpcRequest rpcRequest = new Client.RpcRequest(reqUrl, reqMap, headers, method, timeout, TimeUnit.SECONDS, 0);
        HttpResponseWrapper wrapper = new HttpResponseWrapper();
        try {
            wrapper.setResponse(CLIENT.call(rpcRequest, String.class));
        }
        catch (Throwable e) {
            wrapper.setException(e);
        }
        return wrapper;
    }
}

