/*
 * Decompiled with CFR 0.152.
 */
package cn.icanci.loopstack.rec.engine.script.factory;

import cn.icanci.loopstack.rec.common.enums.ScriptTypeEnum;
import cn.icanci.loopstack.rec.engine.script.enums.ScriptTypeFactoryEnum;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.script.ScriptEngine;

public final class ScriptEngineFactory {
    private static final Map<ScriptTypeEnum, ScriptEngine> SCRIPT_ENGINE_CACHE;

    public static ScriptEngine getScriptEngine(ScriptTypeEnum scriptType) {
        return SCRIPT_ENGINE_CACHE.get(scriptType);
    }

    static {
        ScriptTypeFactoryEnum[] scriptTypeFactory;
        SCRIPT_ENGINE_CACHE = new ConcurrentHashMap<ScriptTypeEnum, ScriptEngine>();
        for (ScriptTypeFactoryEnum factory : scriptTypeFactory = ScriptTypeFactoryEnum.values()) {
            SCRIPT_ENGINE_CACHE.put(factory.getScriptType(), factory.getFactory().getScriptEngine());
        }
    }
}

