/*
 * Decompiled with CFR 0.152.
 */
package cn.icanci.loopstack.rec.engine.script.context;

import cn.icanci.loopstack.rec.common.enums.ScriptTypeEnum;
import java.io.Serializable;
import java.util.StringJoiner;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;

public class RecScriptEngineContext<T>
implements Serializable {
    private static final long serialVersionUID = 6215311466648575581L;
    private ScriptTypeEnum scriptType;
    private String scriptContent;
    private ScriptEngine scriptEngine;
    private Compilable compilable;
    private CompiledScript compiledScript;
    private T retVal;
    private Throwable throwable;
    private Class<T> type;
    private Bindings bindings;

    public boolean isSuccess() {
        return this.retVal != null && this.throwable == null;
    }

    public T getRealRetVal() {
        try {
            if (this.retVal == null) {
                throw new NullPointerException("The script engine execution result is null!");
            }
            if (this.type == Integer.class) {
                return (T)Integer.valueOf(String.valueOf(this.retVal));
            }
            if (this.type == Double.class) {
                return (T)Double.valueOf(String.valueOf(this.retVal));
            }
            if (this.type == Long.class) {
                return (T)Long.valueOf(String.valueOf(this.retVal));
            }
            if (this.type == String.class) {
                return (T)String.valueOf(this.retVal);
            }
            return this.retVal;
        }
        catch (Throwable e) {
            if (this.throwable != null) {
                this.throwable.addSuppressed(e);
            }
            this.throwable = e;
            return null;
        }
    }

    public ScriptTypeEnum getScriptType() {
        return this.scriptType;
    }

    public void setScriptType(ScriptTypeEnum scriptType) {
        this.scriptType = scriptType;
    }

    public String getScriptContent() {
        return this.scriptContent;
    }

    public void setScriptContent(String scriptContent) {
        this.scriptContent = scriptContent;
    }

    public ScriptEngine getScriptEngine() {
        return this.scriptEngine;
    }

    public void setScriptEngine(ScriptEngine scriptEngine) {
        this.scriptEngine = scriptEngine;
    }

    public Compilable getCompilable() {
        return this.compilable;
    }

    public void setCompilable(Compilable compilable) {
        this.compilable = compilable;
    }

    public CompiledScript getCompiledScript() {
        return this.compiledScript;
    }

    public void setCompiledScript(CompiledScript compiledScript) {
        this.compiledScript = compiledScript;
    }

    public void setRetVal(T retVal) {
        this.retVal = retVal;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public void setThrowable(Throwable throwable) {
        this.throwable = throwable;
    }

    public Class<T> getType() {
        return this.type;
    }

    public void setType(Class<T> type) {
        this.type = type;
    }

    public Bindings getBindings() {
        return this.bindings;
    }

    public void setBindings(Bindings bindings) {
        this.bindings = bindings;
    }

    public String toString() {
        return new StringJoiner(",").add("scriptType=" + this.scriptType).add("scriptContent=" + this.scriptContent).add("scriptEngine=" + this.scriptEngine).add("compilable=" + this.compilable).add("compiledScript=" + this.compiledScript).add("retVal=" + this.retVal).add("throwable=" + this.throwable).add("type=" + this.type).add("bindings=" + this.bindings).toString();
    }
}

