/*
 * Decompiled with CFR 0.152.
 */
package cn.icanci.loopstack.rec.engine.script.client.http;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONUtil;
import cn.icanci.loopstack.rec.engine.script.client.AbstractRetryClient;
import cn.icanci.loopstack.rec.engine.script.client.Client;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientImpl
extends AbstractRetryClient {
    private static final Logger logger = LoggerFactory.getLogger(HttpClientImpl.class);
    private static final long DEFAULT_TIMEOUT = 3L;
    private static final TimeUnit DEFAULT_TIMEUNIT = TimeUnit.SECONDS;

    public static Client getInstance() {
        return HttpClientImplHolder.CLIENT_IMPL;
    }

    @Override
    protected <V> V doExecute(Client.RpcRequest request, Class<V> clazz) throws ExecutionException, InterruptedException, TimeoutException {
        FutureTask<V> task = new FutureTask<V>(new HttpCallRunner<V>(request, clazz));
        HTTP_POOL.execute(task);
        return task.get(request.getReadTimeOut(), request.getTimeUnit());
    }

    private static class HttpCallRunner<V>
    implements Callable<V> {
        private final Client.RpcRequest request;
        private final Class<V> clazz;

        public HttpCallRunner(Client.RpcRequest request, Class<V> clazz) {
            this.request = request;
            this.clazz = clazz;
        }

        @Override
        public V call() throws Exception {
            switch (this.request.getMethod()) {
                case GET: {
                    return this.doGet(this.request, this.clazz);
                }
                case POST: {
                    return this.doPost(this.request, this.clazz);
                }
            }
            throw new IllegalAccessException("Un Support Http Method:" + this.request.getMethod());
        }

        private <V> V doGet(Client.RpcRequest request, Class<V> clazz) {
            Map body = Maps.newHashMap();
            if (request.getBody() instanceof Map) {
                body = (Map)request.getBody();
            }
            String getBody = ((HttpRequest)HttpUtil.createGet((String)request.getUrl()).addHeaders(request.getHeaders())).form(body).execute().body();
            logger.info("[{}][HttpCallRunner][doGet] request:{},resp:{}", new Object[]{Thread.currentThread().getName(), JSONUtil.toJsonStr((Object)request), getBody});
            return (V)JSONUtil.toBean((String)getBody, clazz);
        }

        private <V> V doPost(Client.RpcRequest request, Class<V> clazz) {
            String postBody = ((HttpRequest)HttpUtil.createPost((String)request.getUrl()).addHeaders(request.getHeaders())).body(JSONUtil.toJsonStr((Object)request.getBody())).execute().body();
            logger.info("[{}][HttpCallRunner][doPost] request:{},resp:{}", new Object[]{Thread.currentThread().getName(), JSONUtil.toJsonStr((Object)request), postBody});
            return (V)JSONUtil.toBean((String)postBody, clazz);
        }
    }

    private static final class HttpClientImplHolder {
        private static final HttpClientImpl CLIENT_IMPL = new HttpClientImpl();

        private HttpClientImplHolder() {
        }
    }
}

