/*
 * Decompiled with CFR 0.152.
 */
package cn.icanci.loopstack.rec.engine.script.client;

import cn.icanci.loopstack.rec.engine.script.client.Client;
import cn.icanci.loopstack.rec.engine.script.client.RemoteException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class AbstractRetryClient
implements Client {
    protected static final ThreadPoolExecutor HTTP_POOL = new ThreadPoolExecutor(40, 120, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(2000), runnable -> new Thread(runnable, "AbstractRetryClient Pool-" + runnable.hashCode()), (r, executor) -> {
        throw new RuntimeException("AbstractRetryClient Pool is EXHAUSTED!");
    });

    @Override
    public <V> V call(Client.RpcRequest request, Class<V> clazz) throws RemoteException {
        return this.retry(request, clazz, 0, request.getRetry());
    }

    private <V> V retry(Client.RpcRequest request, Class<V> clazz, int retryCount, int retry) throws RemoteException {
        try {
            return this.doExecute(request, clazz);
        }
        catch (RemoteException | InterruptedException | ExecutionException e) {
            throw new RemoteException(e);
        }
        catch (TimeoutException e) {
            if (retryCount < retry) {
                return this.retry(request, clazz, retry, ++retryCount);
            }
            throw new RemoteException(e.getMessage(), (Throwable)e);
        }
    }

    protected abstract <V> V doExecute(Client.RpcRequest var1, Class<V> var2) throws ExecutionException, InterruptedException, TimeoutException;
}

