package cn.icanci.loopstack.rec.admin.biz.mapper.config;

import cn.icanci.loopstack.rec.admin.biz.mapper.convertor.DataSourceTypeEnumConverter;
import cn.icanci.loopstack.rec.admin.biz.mapper.convertor.HttpRequestTypeEnumConverter;
import cn.icanci.loopstack.rec.admin.biz.mapper.convertor.ScriptTypeEnumConverter;
import cn.icanci.loopstack.rec.admin.dal.mongodb.dateobject.DataSourceDO;
import cn.icanci.loopstack.rec.admin.dal.mongodb.dateobject.DataSourceDO.ScriptInfo;
import cn.icanci.loopstack.rec.admin.dal.mongodb.dateobject.DataSourceDO.SqlInfo;
import cn.icanci.loopstack.rec.common.model.config.DataSourceVO;
import cn.icanci.loopstack.rec.common.model.config.DataSourceVO.HttpInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2023-04-18T01:01:38+0800",
    comments = "version: 1.4.2.Final, compiler: javac, environment: Java 1.8.0_332 (Azul Systems, Inc.)"
)
@Component
public class DataSourceMapperImpl implements DataSourceMapper {

    @Autowired
    private DataSourceTypeEnumConverter dataSourceTypeEnumConverter;
    @Autowired
    private ScriptTypeEnumConverter scriptTypeEnumConverter;
    @Autowired
    private HttpRequestTypeEnumConverter httpRequestTypeEnumConverter;

    @Override
    public DataSourceVO do2vo(DataSourceDO t) {
        if ( t == null ) {
            return null;
        }

        DataSourceVO dataSourceVO = new DataSourceVO();

        dataSourceVO.setId( t.getId() );
        dataSourceVO.setUuid( t.getUuid() );
        dataSourceVO.setDesc( t.getDesc() );
        dataSourceVO.setCreateTime( t.getCreateTime() );
        dataSourceVO.setUpdateTime( t.getUpdateTime() );
        dataSourceVO.setIsDelete( t.getIsDelete() );
        dataSourceVO.setEnv( t.getEnv() );
        dataSourceVO.setDomainCode( t.getDomainCode() );
        dataSourceVO.setDataSourceName( t.getDataSourceName() );
        dataSourceVO.setDataSourceType( dataSourceTypeEnumConverter.asEnum( t.getDataSourceType() ) );
        dataSourceVO.setScriptInfo( do2vo( t.getScriptInfo() ) );
        dataSourceVO.setHttpInfo( do2vo( t.getHttpInfo() ) );
        dataSourceVO.setSqlInfo( do2vo( t.getSqlInfo() ) );

        return dataSourceVO;
    }

    @Override
    public List<DataSourceVO> dos2vos(Collection<DataSourceDO> ts) {
        if ( ts == null ) {
            return null;
        }

        List<DataSourceVO> list = new ArrayList<DataSourceVO>( ts.size() );
        for ( DataSourceDO dataSourceDO : ts ) {
            list.add( do2vo( dataSourceDO ) );
        }

        return list;
    }

    @Override
    public DataSourceDO vo2do(DataSourceVO r) {
        if ( r == null ) {
            return null;
        }

        DataSourceDO dataSourceDO = new DataSourceDO();

        dataSourceDO.setId( r.getId() );
        dataSourceDO.setUuid( r.getUuid() );
        dataSourceDO.setDesc( r.getDesc() );
        dataSourceDO.setCreateTime( r.getCreateTime() );
        dataSourceDO.setUpdateTime( r.getUpdateTime() );
        dataSourceDO.setIsDelete( r.getIsDelete() );
        dataSourceDO.setEnv( r.getEnv() );
        dataSourceDO.setDomainCode( r.getDomainCode() );
        dataSourceDO.setDataSourceName( r.getDataSourceName() );
        dataSourceDO.setDataSourceType( dataSourceTypeEnumConverter.asString( r.getDataSourceType() ) );
        dataSourceDO.setScriptInfo( vo2do( r.getScriptInfo() ) );
        dataSourceDO.setHttpInfo( vo2do( r.getHttpInfo() ) );
        dataSourceDO.setSqlInfo( vo2do( r.getSqlInfo() ) );

        return dataSourceDO;
    }

    @Override
    public List<DataSourceDO> vos2dos(List<DataSourceVO> rs) {
        if ( rs == null ) {
            return null;
        }

        List<DataSourceDO> list = new ArrayList<DataSourceDO>( rs.size() );
        for ( DataSourceVO dataSourceVO : rs ) {
            list.add( vo2do( dataSourceVO ) );
        }

        return list;
    }

    @Override
    public cn.icanci.loopstack.rec.common.model.config.DataSourceVO.ScriptInfo do2vo(ScriptInfo scriptInfo) {
        if ( scriptInfo == null ) {
            return null;
        }

        cn.icanci.loopstack.rec.common.model.config.DataSourceVO.ScriptInfo scriptInfo1 = new cn.icanci.loopstack.rec.common.model.config.DataSourceVO.ScriptInfo();

        scriptInfo1.setScriptType( scriptTypeEnumConverter.asEnum( scriptInfo.getScriptType() ) );
        scriptInfo1.setScriptContent( scriptInfo.getScriptContent() );
        scriptInfo1.setTimeout( scriptInfo.getTimeout() );

        return scriptInfo1;
    }

    @Override
    public ScriptInfo vo2do(cn.icanci.loopstack.rec.common.model.config.DataSourceVO.ScriptInfo scriptInfo) {
        if ( scriptInfo == null ) {
            return null;
        }

        ScriptInfo scriptInfo1 = new ScriptInfo();

        scriptInfo1.setScriptType( scriptTypeEnumConverter.asString( scriptInfo.getScriptType() ) );
        scriptInfo1.setScriptContent( scriptInfo.getScriptContent() );
        scriptInfo1.setTimeout( scriptInfo.getTimeout() );

        return scriptInfo1;
    }

    @Override
    public HttpInfo do2vo(cn.icanci.loopstack.rec.admin.dal.mongodb.dateobject.DataSourceDO.HttpInfo httpInfo) {
        if ( httpInfo == null ) {
            return null;
        }

        HttpInfo httpInfo1 = new HttpInfo();

        httpInfo1.setHttpRequestType( httpRequestTypeEnumConverter.asEnum( httpInfo.getHttpRequestType() ) );
        httpInfo1.setReqUrl( httpInfo.getReqUrl() );
        httpInfo1.setReqParam( httpInfo.getReqParam() );
        httpInfo1.setTimeout( httpInfo.getTimeout() );

        return httpInfo1;
    }

    @Override
    public cn.icanci.loopstack.rec.admin.dal.mongodb.dateobject.DataSourceDO.HttpInfo vo2do(HttpInfo httpInfo) {
        if ( httpInfo == null ) {
            return null;
        }

        cn.icanci.loopstack.rec.admin.dal.mongodb.dateobject.DataSourceDO.HttpInfo httpInfo1 = new cn.icanci.loopstack.rec.admin.dal.mongodb.dateobject.DataSourceDO.HttpInfo();

        httpInfo1.setHttpRequestType( httpRequestTypeEnumConverter.asString( httpInfo.getHttpRequestType() ) );
        httpInfo1.setReqUrl( httpInfo.getReqUrl() );
        httpInfo1.setReqParam( httpInfo.getReqParam() );
        httpInfo1.setTimeout( httpInfo.getTimeout() );

        return httpInfo1;
    }

    @Override
    public cn.icanci.loopstack.rec.common.model.config.DataSourceVO.SqlInfo do2vo(SqlInfo sqlInfo) {
        if ( sqlInfo == null ) {
            return null;
        }

        cn.icanci.loopstack.rec.common.model.config.DataSourceVO.SqlInfo sqlInfo1 = new cn.icanci.loopstack.rec.common.model.config.DataSourceVO.SqlInfo();

        sqlInfo1.setSql( sqlInfo.getSql() );
        sqlInfo1.setTimeout( sqlInfo.getTimeout() );

        return sqlInfo1;
    }

    @Override
    public SqlInfo vo2do(cn.icanci.loopstack.rec.common.model.config.DataSourceVO.SqlInfo sqlInfo) {
        if ( sqlInfo == null ) {
            return null;
        }

        SqlInfo sqlInfo1 = new SqlInfo();

        sqlInfo1.setSql( sqlInfo.getSql() );
        sqlInfo1.setTimeout( sqlInfo.getTimeout() );

        return sqlInfo1;
    }
}
