package cn.ibizlab.central.plugin.odoo;

import static java.util.Arrays.asList;

import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.LogFactory;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;

import cn.ibizlab.central.plugin.odoo.dataentity.OdooDataEntityRuntime;
import cn.ibizlab.central.plugin.odoo.service.OdooSubSysServiceAPIRuntime;
import net.ibizsys.central.cloud.core.ServiceSystemRuntime;
import net.ibizsys.central.dataentity.IDataEntityRuntime;
import net.ibizsys.central.service.ISubSysServiceAPIRuntime;
import net.ibizsys.model.service.IPSSubSysServiceAPI;

public class OdooSystemRuntime extends ServiceSystemRuntime {

	private static final org.apache.commons.logging.Log log = LogFactory.getLog(OdooSystemRuntime.class);

	
	@Override
	protected IDataEntityRuntime createDefaultDataEntityRuntime() {
		return new OdooDataEntityRuntime();
	}
	
	
	@Override
	protected ISubSysServiceAPIRuntime createSubSysServiceAPIRuntime(IPSSubSysServiceAPI iPSSubSysServiceAPI) {
		
		if(OdooSubSysServiceAPIRuntime.APITAG_ODOOCLIENT.equalsIgnoreCase(iPSSubSysServiceAPI.getAPITag())
				|| OdooSubSysServiceAPIRuntime.APITAG_ODOOCLIENT.equalsIgnoreCase(iPSSubSysServiceAPI.getCodeName())) {
			ISubSysServiceAPIRuntime iSubSysServiceAPIRuntime = this.getRuntimeObject(iPSSubSysServiceAPI.getPSSysSFPlugin(), ISubSysServiceAPIRuntime.class, true);
			if (iSubSysServiceAPIRuntime != null) {
				return iSubSysServiceAPIRuntime;
			}
			return new OdooSubSysServiceAPIRuntime();
		}
		
		
		return super.createSubSysServiceAPIRuntime(iPSSubSysServiceAPI);
	}
	

	public static void main(String[] args) {

		try {

			// 登录测试
			final XmlRpcClient client = new XmlRpcClient();

			final XmlRpcClientConfigImpl start_config = new XmlRpcClientConfigImpl();
			start_config.setServerURL(new URL("http://172.16.240.23:8069/xmlrpc/2/common"));
			final Map<String, Object> info = (Map<String, Object>) client.execute(start_config, "version", new Object[0]);

			// final Object url = info.get("host"),
			// db = info.get("database"),
			// username = info.get("user"),
			// password = info.get("password");

			String url = "http://172.16.240.23:8069";
			String db = "";// "odoo";
			String username = "odoo@ibizsys.net";
			String password = "c4bc061f451a0f816eb3352e24dcc22a220c5678";

			int uid = (int) client.execute(start_config, "authenticate", Arrays.asList(db, username, password, new HashMap<>()));

			final XmlRpcClient models = new XmlRpcClient() {
				{
					setConfig(new XmlRpcClientConfigImpl() {
						{
							setServerURL(new URL(String.format("%s/xmlrpc/2/object", url)));
						}
					});
				}
			};

			if (true) {
				List list = asList((Object[]) models.execute("execute_kw", asList(db, uid, password, "res.partner", "search_read", asList(asList(asList("is_company", "=", true))), new HashMap() {
					{
						put("fields", asList("name", "country_id", "comment"));
						put("limit", 5);
					}
				})));

				System.out.print("测试");
			}

			if (true) {
				List list = asList((Object[]) models.execute("execute_kw", asList(db, uid, password, "ir.model", "search_read", asList(asList(asList("name", "like", "Portal"))), new HashMap() {
					{
						put("fields", asList("name", "id", "model"));
						put("limit", 5);
					}
				})));

				System.out.print("测试");
			}
			//
			// if(true) {
			// Object objRet = models.execute(
			// "execute_kw", asList(
			// db, uid, password,
			// "ir.model.fields", "create",
			// asList(new HashMap<String, Object>() {{
			// put("model_id", 96);
			// put("name", "x_name");
			// put("ttype", "char");
			// put("state", "manual");
			// put("required", false);
			// }})
			// ));
			// System.out.print("测试");
			// }

			if (true) {
				Object objRet = models.execute("execute_kw", asList(db, uid, password, "res.users", "create", asList(new HashMap<String, Object>() {
					{
						put("company_id", 1);
						put("name", "test4");
						put("login", "test4@odoo.com");
						put("password", "123456");
					}
				})));

				Object objRet2 = models.execute("execute_kw", asList(db, uid, password, "res.users", "write", asList(asList(objRet), new HashMap<String, Object>() {
					{
						put("password", "654321");
					}
				})));

				System.out.print("测试");
			}

			System.out.print("测试");
		} catch (Exception ex) {
			ex.printStackTrace();
		}

	}

}
