package net.ibizsys.codegen.template.rtmodel.dsl.wf;

import java.io.File;
import java.io.Writer;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.codegen.template.rtmodel.dsl.IModelDSLGenEngineContext;

public class WorkflowWriter extends net.ibizsys.codegen.template.rtmodel.dsl.ModelObjectWriter{

	protected void onWrite(IModelDSLGenEngineContext iModelDSLGenEngineContext, Writer writer, IPSModelObject object, String indent) throws Exception{
		
		net.ibizsys.model.wf.IPSWorkflow iPSWorkflow = (net.ibizsys.model.wf.IPSWorkflow)object;
		
		this.write(writer, "codeName", iPSWorkflow.getCodeName(), "", indent);
		this.write(writer, "entityWFCancelState", iPSWorkflow.getEntityWFCancelState(), "", indent);
		this.write(writer, "entityWFErrorState", iPSWorkflow.getEntityWFErrorState(), "", indent);
		this.write(writer, "entityWFFinishState", iPSWorkflow.getEntityWFFinishState(), "", indent);
		this.write(writer, "entityWFState", iPSWorkflow.getEntityWFState(), "", indent);
		this.write(writer, "logicName", iPSWorkflow.getLogicName(), "", indent);
		this.write(writer, "nameLanguageRes", iPSWorkflow.getNamePSLanguageRes(), "", indent);
		this.write(writer, "systemModule", iPSWorkflow.getPSSystemModule(), null, indent);
		if(iPSWorkflow.getPSWFDEs() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.wf.IPSWorkflow.class, "getPSWFDEs", false)){
			writer.write(indent);
			writer.write("wfdes {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.wf.WFDEListWriter.class, writer, iPSWorkflow.getPSWFDEs(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSWorkflow.getPSWFVersions() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.wf.IPSWorkflow.class, "getPSWFVersions", false)){
			writer.write(indent);
			writer.write("wfversions {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.wf.WFVersionListWriter.class, writer, iPSWorkflow.getPSWFVersions(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		this.write(writer, "wfengineCat", iPSWorkflow.getWFEngineCat(), "", indent);
		this.write(writer, "wfengineType", iPSWorkflow.getWFEngineType(), "", indent);
		this.write(writer, "wfproxyMode", iPSWorkflow.getWFProxyMode(), "0", indent);
		this.write(writer, "wfsn", iPSWorkflow.getWFSN(), "", indent);
		this.write(writer, "wftype", iPSWorkflow.getWFType(), "", indent);
		this.write(writer, "useRemoteEngine", iPSWorkflow.isUseRemoteEngine(), "false", indent);
		this.write(writer, "useWFProxyApp", iPSWorkflow.isUseWFProxyApp(), "false", indent);
		this.write(writer, "valid", iPSWorkflow.isValid(), "false", indent);

		super.onWrite(iModelDSLGenEngineContext, writer, object, indent);
	}
	protected void onExport(IModelDSLGenEngineContext iModelDSLGenEngineContext, IPSModelObject object) throws Exception{
		
		net.ibizsys.model.wf.IPSWorkflow iPSWorkflow = (net.ibizsys.model.wf.IPSWorkflow)object;
		
		//默认不导出
		if(iPSWorkflow.getPSWFDEs() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.wf.IPSWorkflow.class, "getPSWFDEs", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.wf.WFDEListWriter.class, iPSWorkflow.getPSWFDEs());
		}
		//默认不导出
		if(iPSWorkflow.getPSWFVersions() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.wf.IPSWorkflow.class, "getPSWFVersions", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.wf.WFVersionListWriter.class, iPSWorkflow.getPSWFVersions());
		}

		super.onExport(iModelDSLGenEngineContext, object);
	}
}