package net.ibizsys.codegen.template.rtmodel.dsl.wf;

import java.io.Writer;
import java.util.List;
import net.ibizsys.codegen.template.rtmodel.dsl.ModelListWriterBase;
import net.ibizsys.codegen.template.rtmodel.dsl.IModelDSLGenEngineContext;

public class WFLinkListWriter extends ModelListWriterBase<net.ibizsys.model.wf.IPSWFLink>{
	@Override
	protected void onWrite(IModelDSLGenEngineContext iModelDSLGenEngineContext, Writer writer, List<net.ibizsys.model.wf.IPSWFLink> list, String indent) throws Exception {
		for(net.ibizsys.model.wf.IPSWFLink item : list) {
			if("IAACTION".equals(item.getWFLinkType())){
				writer.write(indent);
				writer.write("iaaction {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.wf.WFInteractiveLinkWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			if("ROUTE".equals(item.getWFLinkType())){
				writer.write(indent);
				writer.write("route {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.wf.WFRouteLinkWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			if("TIMEOUT".equals(item.getWFLinkType())){
				writer.write(indent);
				writer.write("timeout {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.wf.WFTimeoutLinkWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			if("WFRETURN".equals(item.getWFLinkType())){
				writer.write(indent);
				writer.write("wfreturn {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.wf.WFEmbedWFReturnLinkWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			
			writer.write(indent);
			writer.write("item {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.wf.WFLinkWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		//super.onWrite(writer, list, indent);
	}
	
	@Override
	protected void onExport(IModelDSLGenEngineContext iModelDSLGenEngineContext, List<net.ibizsys.model.wf.IPSWFLink> list) throws Exception {
		for(net.ibizsys.model.wf.IPSWFLink item : list) {
			if("IAACTION".equals(item.getWFLinkType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.wf.WFInteractiveLinkWriter.class, item, "WFLink");
				continue;
			}
			if("ROUTE".equals(item.getWFLinkType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.wf.WFRouteLinkWriter.class, item, "WFLink");
				continue;
			}
			if("TIMEOUT".equals(item.getWFLinkType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.wf.WFTimeoutLinkWriter.class, item, "WFLink");
				continue;
			}
			if("WFRETURN".equals(item.getWFLinkType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.wf.WFEmbedWFReturnLinkWriter.class, item, "WFLink");
				continue;
			}
			
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.wf.WFLinkWriter.class, item, "WFLink");
		}
		//super.onExport(root, list);
	}
	
}