package net.ibizsys.codegen.template.rtmodel.dsl.testing;

import java.io.File;
import java.io.Writer;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.codegen.template.rtmodel.dsl.IModelDSLGenEngineContext;

public class SysTestPrjWriter extends net.ibizsys.codegen.template.rtmodel.dsl.ModelObjectWriter{

	protected void onWrite(IModelDSLGenEngineContext iModelDSLGenEngineContext, Writer writer, IPSModelObject object, String indent) throws Exception{
		
		net.ibizsys.model.testing.IPSSysTestPrj iPSSysTestPrj = (net.ibizsys.model.testing.IPSSysTestPrj)object;
		
		this.write(writer, "codeName", iPSSysTestPrj.getCodeName(), "", indent);
		this.write(writer, "application", iPSSysTestPrj.getPSApplication(), null, indent);
		this.write(writer, "sysServiceAPI", iPSSysTestPrj.getPSSysServiceAPI(), null, indent);
		if(iPSSysTestPrj.getPSSysTestModules() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.testing.IPSSysTestPrj.class, "getPSSysTestModules", false)){
			writer.write(indent);
			writer.write("sysTestModules {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.testing.SysTestModuleListWriter.class, writer, iPSSysTestPrj.getPSSysTestModules(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		this.write(writer, "prjTag", iPSSysTestPrj.getPrjTag(), "", indent);
		this.write(writer, "prjTag2", iPSSysTestPrj.getPrjTag2(), "", indent);
		this.write(writer, "prjType", iPSSysTestPrj.getPrjType(), "", indent);

		super.onWrite(iModelDSLGenEngineContext, writer, object, indent);
	}
	protected void onExport(IModelDSLGenEngineContext iModelDSLGenEngineContext, IPSModelObject object) throws Exception{
		
		net.ibizsys.model.testing.IPSSysTestPrj iPSSysTestPrj = (net.ibizsys.model.testing.IPSSysTestPrj)object;
		
		//默认不导出
		if(iPSSysTestPrj.getPSSysTestModules() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.testing.IPSSysTestPrj.class, "getPSSysTestModules", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.testing.SysTestModuleListWriter.class, iPSSysTestPrj.getPSSysTestModules());
		}

		super.onExport(iModelDSLGenEngineContext, object);
	}
}