package net.ibizsys.codegen.template.rtmodel.dsl.testing;

import java.io.File;
import java.io.Writer;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.codegen.template.rtmodel.dsl.IModelDSLGenEngineContext;

public class SysTestDataWriter extends net.ibizsys.codegen.template.rtmodel.dsl.ModelObjectWriter{

	protected void onWrite(IModelDSLGenEngineContext iModelDSLGenEngineContext, Writer writer, IPSModelObject object, String indent) throws Exception{
		
		net.ibizsys.model.testing.IPSSysTestData iPSSysTestData = (net.ibizsys.model.testing.IPSSysTestData)object;
		
		this.write(writer, "codeName", iPSSysTestData.getCodeName(), "", indent);
		this.write(writer, "data", iPSSysTestData.getData(), "", indent);
		this.write(writer, "instCount", iPSSysTestData.getInstCount(), "0", indent);
		this.write(writer, "dataEntity", iPSSysTestData.getPSDataEntity(), null, indent);
		if(iPSSysTestData.getPSSysTestDataItems() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.testing.IPSSysTestData.class, "getPSSysTestDataItems", false)){
			writer.write(indent);
			writer.write("items {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.testing.SysTestDataItemListWriter.class, writer, iPSSysTestData.getPSSysTestDataItems(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		this.write(writer, "scriptCode", iPSSysTestData.getScriptCode(), "", indent);
		this.write(writer, "testDataType", iPSSysTestData.getTestDataType(), "", indent);
		this.write(writer, "baseMode", iPSSysTestData.isBaseMode(), "false", indent);

		super.onWrite(iModelDSLGenEngineContext, writer, object, indent);
	}
	protected void onExport(IModelDSLGenEngineContext iModelDSLGenEngineContext, IPSModelObject object) throws Exception{
		
		net.ibizsys.model.testing.IPSSysTestData iPSSysTestData = (net.ibizsys.model.testing.IPSSysTestData)object;
		
		//默认不导出
		if(iPSSysTestData.getPSSysTestDataItems() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.testing.IPSSysTestData.class, "getPSSysTestDataItems", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.testing.SysTestDataItemListWriter.class, iPSSysTestData.getPSSysTestDataItems());
		}

		super.onExport(iModelDSLGenEngineContext, object);
	}
}