package net.ibizsys.codegen.template.rtmodel.dsl.res;

import java.io.File;
import java.io.Writer;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.codegen.template.rtmodel.dsl.IModelDSLGenEngineContext;

public class SysLanWriter extends net.ibizsys.codegen.template.rtmodel.dsl.ModelObjectWriter{

	protected void onWrite(IModelDSLGenEngineContext iModelDSLGenEngineContext, Writer writer, IPSModelObject object, String indent) throws Exception{
		
		net.ibizsys.model.res.IPSSysLan iPSSysLan = (net.ibizsys.model.res.IPSSysLan)object;
		
		if(iPSSysLan.getAllPSLanguageItems() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.res.IPSSysLan.class, "getAllPSLanguageItems", false)){
			writer.write(indent);
			writer.write("languageItems {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.res.LanguageItemListWriter.class, writer, iPSSysLan.getAllPSLanguageItems(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		this.write(writer, "language", iPSSysLan.getLanguage(), "", indent);

		super.onWrite(iModelDSLGenEngineContext, writer, object, indent);
	}
	protected void onExport(IModelDSLGenEngineContext iModelDSLGenEngineContext, IPSModelObject object) throws Exception{
		
		net.ibizsys.model.res.IPSSysLan iPSSysLan = (net.ibizsys.model.res.IPSSysLan)object;
		
		//默认不导出
		if(iPSSysLan.getAllPSLanguageItems() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.res.IPSSysLan.class, "getAllPSLanguageItems", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.res.LanguageItemListWriter.class, iPSSysLan.getAllPSLanguageItems());
		}

		super.onExport(iModelDSLGenEngineContext, object);
	}
}