package net.ibizsys.codegen.template.rtmodel.dsl.eai;

import java.io.File;
import java.io.Writer;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.codegen.template.rtmodel.dsl.IModelDSLGenEngineContext;

public class SysEAIElementWriter extends net.ibizsys.codegen.template.rtmodel.dsl.eai.SysEAISchemeObjectWriter{

	protected void onWrite(IModelDSLGenEngineContext iModelDSLGenEngineContext, Writer writer, IPSModelObject object, String indent) throws Exception{
		
		net.ibizsys.model.eai.IPSSysEAIElement iPSSysEAIElement = (net.ibizsys.model.eai.IPSSysEAIElement)object;
		
		if(iPSSysEAIElement.getAllPSSysEAIElementAttrs() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.eai.IPSSysEAIElement.class, "getAllPSSysEAIElementAttrs", false)){
			writer.write(indent);
			writer.write("attrs {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.eai.SysEAIElementAttrListWriter.class, writer, iPSSysEAIElement.getAllPSSysEAIElementAttrs(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSSysEAIElement.getAllPSSysEAIElementREs() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.eai.IPSSysEAIElement.class, "getAllPSSysEAIElementREs", false)){
			writer.write(indent);
			writer.write("res {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.eai.SysEAIElementREListWriter.class, writer, iPSSysEAIElement.getAllPSSysEAIElementREs(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}

		super.onWrite(iModelDSLGenEngineContext, writer, object, indent);
	}
	protected void onExport(IModelDSLGenEngineContext iModelDSLGenEngineContext, IPSModelObject object) throws Exception{
		
		net.ibizsys.model.eai.IPSSysEAIElement iPSSysEAIElement = (net.ibizsys.model.eai.IPSSysEAIElement)object;
		
		//默认不导出
		if(iPSSysEAIElement.getAllPSSysEAIElementAttrs() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.eai.IPSSysEAIElement.class, "getAllPSSysEAIElementAttrs", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.eai.SysEAIElementAttrListWriter.class, iPSSysEAIElement.getAllPSSysEAIElementAttrs());
		}
		//默认不导出
		if(iPSSysEAIElement.getAllPSSysEAIElementREs() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.eai.IPSSysEAIElement.class, "getAllPSSysEAIElementREs", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.eai.SysEAIElementREListWriter.class, iPSSysEAIElement.getAllPSSysEAIElementREs());
		}

		super.onExport(iModelDSLGenEngineContext, object);
	}
}