package net.ibizsys.codegen.template.rtmodel.dsl.dataentity.ds;

import java.io.File;
import java.io.Writer;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.codegen.template.rtmodel.dsl.IModelDSLGenEngineContext;

public class DEDataQueryCodeWriter extends net.ibizsys.codegen.template.rtmodel.dsl.ModelObjectWriter{

	protected void onWrite(IModelDSLGenEngineContext iModelDSLGenEngineContext, Writer writer, IPSModelObject object, String indent) throws Exception{
		
		net.ibizsys.model.dataentity.ds.IPSDEDataQueryCode iPSDEDataQueryCode = (net.ibizsys.model.dataentity.ds.IPSDEDataQueryCode)object;
		
		this.write(writer, "dbtype", iPSDEDataQueryCode.getDBType(), "", indent);
		if(iPSDEDataQueryCode.getPSDEDataQueryCodeConds() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.ds.IPSDEDataQueryCode.class, "getPSDEDataQueryCodeConds", false)){
			writer.write(indent);
			writer.write("conds {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.ds.DEDataQueryCodeCondListWriter.class, writer, iPSDEDataQueryCode.getPSDEDataQueryCodeConds(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSDEDataQueryCode.getPSDEDataQueryCodeExps() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.ds.IPSDEDataQueryCode.class, "getPSDEDataQueryCodeExps", false)){
			writer.write(indent);
			writer.write("exps {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.ds.DEDataQueryCodeExpListWriter.class, writer, iPSDEDataQueryCode.getPSDEDataQueryCodeExps(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		this.write(writer, "queryCode", iPSDEDataQueryCode.getQueryCode(), "", indent);

		super.onWrite(iModelDSLGenEngineContext, writer, object, indent);
	}
	protected void onExport(IModelDSLGenEngineContext iModelDSLGenEngineContext, IPSModelObject object) throws Exception{
		
		net.ibizsys.model.dataentity.ds.IPSDEDataQueryCode iPSDEDataQueryCode = (net.ibizsys.model.dataentity.ds.IPSDEDataQueryCode)object;
		
		//默认不导出
		if(iPSDEDataQueryCode.getPSDEDataQueryCodeConds() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.ds.IPSDEDataQueryCode.class, "getPSDEDataQueryCodeConds", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.ds.DEDataQueryCodeCondListWriter.class, iPSDEDataQueryCode.getPSDEDataQueryCodeConds());
		}
		//默认不导出
		if(iPSDEDataQueryCode.getPSDEDataQueryCodeExps() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.ds.IPSDEDataQueryCode.class, "getPSDEDataQueryCodeExps", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.ds.DEDataQueryCodeExpListWriter.class, iPSDEDataQueryCode.getPSDEDataQueryCodeExps());
		}

		super.onExport(iModelDSLGenEngineContext, object);
	}
}