package net.ibizsys.codegen.template.rtmodel.dsl.dataentity.ds;

import java.io.Writer;
import java.util.List;
import net.ibizsys.codegen.template.rtmodel.dsl.ModelListWriterBase;
import net.ibizsys.codegen.template.rtmodel.dsl.IModelDSLGenEngineContext;

public class DEDQConditionListWriter extends ModelListWriterBase<net.ibizsys.model.dataentity.ds.IPSDEDQCondition>{
	@Override
	protected void onWrite(IModelDSLGenEngineContext iModelDSLGenEngineContext, Writer writer, List<net.ibizsys.model.dataentity.ds.IPSDEDQCondition> list, String indent) throws Exception {
		for(net.ibizsys.model.dataentity.ds.IPSDEDQCondition item : list) {
			if("CUSTOM".equals(item.getCondType())){
				writer.write(indent);
				writer.write("custom {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.ds.DEDQCustomConditionWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			if("GROUP".equals(item.getCondType())){
				writer.write(indent);
				writer.write("group {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.ds.DEDQGroupConditionWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			if("SINGLE".equals(item.getCondType())){
				writer.write(indent);
				writer.write("single {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.ds.DEDQFieldConditionWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
		}
		//super.onWrite(writer, list, indent);
	}
	
	@Override
	protected void onExport(IModelDSLGenEngineContext iModelDSLGenEngineContext, List<net.ibizsys.model.dataentity.ds.IPSDEDQCondition> list) throws Exception {
		for(net.ibizsys.model.dataentity.ds.IPSDEDQCondition item : list) {
			if("CUSTOM".equals(item.getCondType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.ds.DEDQCustomConditionWriter.class, item, "DEDQCondition");
				continue;
			}
			if("GROUP".equals(item.getCondType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.ds.DEDQGroupConditionWriter.class, item, "DEDQCondition");
				continue;
			}
			if("SINGLE".equals(item.getCondType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.ds.DEDQFieldConditionWriter.class, item, "DEDQCondition");
				continue;
			}
		}
		//super.onExport(root, list);
	}
	
}