package net.ibizsys.codegen.template.rtmodel.dsl.database;

import java.io.File;
import java.io.Writer;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.codegen.template.rtmodel.dsl.IModelDSLGenEngineContext;

public class SysDBSchemeWriter extends net.ibizsys.codegen.template.rtmodel.dsl.ModelObjectWriter{

	protected void onWrite(IModelDSLGenEngineContext iModelDSLGenEngineContext, Writer writer, IPSModelObject object, String indent) throws Exception{
		
		net.ibizsys.model.database.IPSSysDBScheme iPSSysDBScheme = (net.ibizsys.model.database.IPSSysDBScheme)object;
		
		if(iPSSysDBScheme.getAllPSSysDBTables() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.database.IPSSysDBScheme.class, "getAllPSSysDBTables", false)){
			writer.write(indent);
			writer.write("tables {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.database.SysDBTableListWriter.class, writer, iPSSysDBScheme.getAllPSSysDBTables(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		this.write(writer, "codeName", iPSSysDBScheme.getCodeName(), "", indent);
		this.write(writer, "codeName2", iPSSysDBScheme.getCodeName2(), "", indent);
		this.write(writer, "dbinstTag", iPSSysDBScheme.getDBInstTag(), "", indent);
		this.write(writer, "dslink", iPSSysDBScheme.getDSLink(), "", indent);
		this.write(writer, "sysModelGroup", iPSSysDBScheme.getPSSysModelGroup(), null, indent);
		this.write(writer, "sysSFPlugin", iPSSysDBScheme.getPSSysSFPlugin(), "", indent);
		this.write(writer, "systemModule", iPSSysDBScheme.getPSSystemModule(), null, indent);
		this.write(writer, "saaSDCIdColumnName", iPSSysDBScheme.getSaaSDCIdColumnName(), "", indent);
		this.write(writer, "saaSDataIdColumnName", iPSSysDBScheme.getSaaSDataIdColumnName(), "", indent);
		this.write(writer, "schemeTag", iPSSysDBScheme.getSchemeTag(), "", indent);
		this.write(writer, "schemeTag2", iPSSysDBScheme.getSchemeTag2(), "", indent);
		this.write(writer, "autoExtendModel", iPSSysDBScheme.isAutoExtendModel(), "false", indent);
		this.write(writer, "existingModel", iPSSysDBScheme.isExistingModel(), "false", indent);
		this.write(writer, "pubIndex", iPSSysDBScheme.isPubIndex(), "false", indent);

		super.onWrite(iModelDSLGenEngineContext, writer, object, indent);
	}
	protected void onExport(IModelDSLGenEngineContext iModelDSLGenEngineContext, IPSModelObject object) throws Exception{
		
		net.ibizsys.model.database.IPSSysDBScheme iPSSysDBScheme = (net.ibizsys.model.database.IPSSysDBScheme)object;
		
		//默认不导出
		if(iPSSysDBScheme.getAllPSSysDBTables() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.database.IPSSysDBScheme.class, "getAllPSSysDBTables", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.database.SysDBTableListWriter.class, iPSSysDBScheme.getAllPSSysDBTables());
		}

		super.onExport(iModelDSLGenEngineContext, object);
	}
}