package net.ibizsys.codegen.template.rtmodel.dsl;

import java.io.File;
import java.io.Writer;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.codegen.template.rtmodel.dsl.IModelDSLGenEngineContext;

public abstract class ModelObjectWriter extends ModelWriterBase{

	protected void onWrite(IModelDSLGenEngineContext iModelDSLGenEngineContext, Writer writer, IPSModelObject object, String indent) throws Exception{
		
		net.ibizsys.model.IPSModelObject iPSModelObject = (net.ibizsys.model.IPSModelObject)object;
		
		this.write(writer, "codeName", iPSModelObject.getCodeName(), "", indent);
		this.write(writer, "memo", iPSModelObject.getMemo(), "", indent);
		this.write(writer, "name", iPSModelObject.getName(), "", indent);
		this.write(writer, "userCat", iPSModelObject.getUserCat(), "", indent);
		this.write(writer, "userTag", iPSModelObject.getUserTag(), "", indent);
		this.write(writer, "userTag2", iPSModelObject.getUserTag2(), "", indent);
		this.write(writer, "userTag3", iPSModelObject.getUserTag3(), "", indent);
		this.write(writer, "userTag4", iPSModelObject.getUserTag4(), "", indent);

		super.onWrite(iModelDSLGenEngineContext, writer, object, indent);
	}
	protected void onExport(IModelDSLGenEngineContext iModelDSLGenEngineContext, IPSModelObject object) throws Exception{
		
		net.ibizsys.model.IPSModelObject iPSModelObject = (net.ibizsys.model.IPSModelObject)object;
		

		super.onExport(iModelDSLGenEngineContext, object);
	}
}