package net.ibizsys.codegen.template.rtmodel.dsl;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.util.StringUtils;

import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.IPSSystem;

public class ModelDSLGenEngine{

	private static final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog(ModelDSLGenEngine.class);
	
	
	private String indent = "    ";
	private Map<Class<?>, IModelListWriter<?>> modelListWriterMap = new HashMap<Class<?>, IModelListWriter<?>>();
	private Map<Class<?>, IModelWriter> modelWriterMap = new HashMap<Class<?>, IModelWriter>(); 
	private File rootFolder = null;
	private IModelDSLGenEngineContext iModelDSLGenEngineContext = new IModelDSLGenEngineContext() {

		@Override
		public String getIndent() {
			return getSelf().getIndent();
		}

		@Override
		public boolean isExportModelFile(Class<?> modelCls, String modelProperty, boolean def) {
			return getSelf().isExportModelFile(modelCls, modelProperty, def);
		}

		

		@Override
		public void write(Class<?> writerCls, Writer writer, List list, String indent) throws Exception {
			getSelf().write(writerCls, writer, list, indent);
		}
		
		@Override
		public void export(Class<?> writerCls, List list) throws Exception {
			getSelf().export(writerCls, list);
		}
		
		@Override
		public void write(Class<?> writerCls, Writer writer, IPSModelObject iPSModelObject, String indent) throws Exception {
			getSelf().write(writerCls, writer, iPSModelObject, indent);
		}

		
		@Override
		public void export(Class<?> writerCls, IPSModelObject iPSModelObject, String defaultType) throws Exception {
			getSelf().export(writerCls, iPSModelObject, defaultType);
		}
		
		
	};
	
	protected IModelDSLGenEngineContext getModelDSLGenEngineContext() {
		return this.iModelDSLGenEngineContext;
	}
	
	private ModelDSLGenEngine getSelf() {
		return this;
	}
	
	public ModelDSLGenEngine(File rootFolder) {
		this.rootFolder = rootFolder;
	}
	
	public File getRootFolder() {
		return this.rootFolder;
	}
	
	public IModelListWriter<?> getModelListWriter(Class<?> cls) throws Exception{
		
		IModelListWriter<?> modelListWriter = this.modelListWriterMap.get(cls);
		if(modelListWriter == null) {
			modelListWriter = (IModelListWriter)cls.newInstance();
			this.modelListWriterMap.put(cls, modelListWriter);
		}
		return modelListWriter;
	}
	
	public IModelWriter getModelWriter(Class<?> cls) throws Exception{
		IModelWriter modelWriter = this.modelWriterMap.get(cls);
		if(modelWriter == null) {
			modelWriter = (IModelWriter)cls.newInstance();
			this.modelWriterMap.put(cls, modelWriter);
		}
		return modelWriter;
	}
	
	public void setModelListWriter(Class<?> cls, IModelListWriter<?> modelListWriter) {
		this.modelListWriterMap.put(cls, modelListWriter);
	}
	
	public void setModelWriter(Class<?> cls, IModelWriter modelLWriter) {
		this.modelWriterMap.put(cls, modelLWriter);
	}
	
	public String getIndent() {
		return indent;
	}
	
	public void setIndent(String indent) {
		this.indent = indent;
	}
	
	protected boolean isExportModelFile(Class<?> modelCls, String modelProperty, boolean def) {
		return def;
	}
	
	protected void write(Class<?> writerCls, Writer writer, List<?> list, String indent) throws Exception {
		IModelListWriter iModelListWriter = this.getModelListWriter(writerCls);
		iModelListWriter.write(this.getModelDSLGenEngineContext(), writer, list, indent);
	}
	
	
	protected void export(Class<?> writerCls, List<?> list) throws Exception {
		IModelListWriter iModelListWriter = this.getModelListWriter(writerCls);
		iModelListWriter.export(this.getModelDSLGenEngineContext(), list);
	}
	
	protected void write(Class<?> writerCls, Writer writer, IPSModelObject iPSModelObject, String indent) throws Exception {
		IModelWriter iModelWriter = this.getModelWriter(writerCls);
		iModelWriter.write(this.getModelDSLGenEngineContext(), writer, iPSModelObject, indent);
	}

	public void export(IPSSystem iPSSystem) throws Exception {
		this.export(SystemWriter.class, iPSSystem, null);
	}
	
	public void export(Class<?> writerCls, IPSModelObject iPSModelObject, String defaultType) throws Exception {
		IModelWriter iModelWriter = this.getModelWriter(writerCls);
		
		//生产当前文件
		String modelFile = getFileName(iPSModelObject, defaultType);
		File file = null;
		if(StringUtils.hasLength(defaultType)) {
			file = new File(getRootFolder().getCanonicalPath() + File.separator + defaultType.toLowerCase() + File.separator + modelFile + ".groovy");
		}
		else {
			file = new File(getRootFolder().getCanonicalPath() + File.separator +  modelFile + ".groovy");
		}
		
		if(!file.getParentFile().exists()) {
			file.getParentFile().mkdirs();
		}
		
		iModelWriter.export(this.getModelDSLGenEngineContext(), iPSModelObject);
		
		try(FileWriter fileWriter = new FileWriter(file)){
			iModelWriter.write(iModelDSLGenEngineContext, fileWriter, iPSModelObject, "");
		}
		
		
	}
	
	protected String getFileName(IPSModelObject iPSModelObject, String defaultType) throws Exception{
		
		String strId = iPSModelObject.getId();
		if(!StringUtils.hasLength(strId)) {
			throw new Exception(String.format("模型[%1$s]未指定标识", iPSModelObject.getName()));
		}
		
		int nPos = strId.indexOf(".json");
		if(nPos != -1 && nPos == (strId.length() - 5)) {
			strId = strId.substring(0, strId.length() - 5);
		}
		
		if(!StringUtils.hasLength(strId)) {
			throw new Exception(String.format("模型[%1$s]未指定标识", iPSModelObject.getName()));
		}
		
		StringBuilder sb = new StringBuilder();
//		if(StringUtils.hasLength(defaultType)) {
//			sb.append(defaultType.toLowerCase());
//		}
		
		String[] ids = strId.split("[/]");
		if(ids.length > 1) {
			for(int i = 0;i<ids.length -1 ;i++) {
				if(i%2 == 0) {
					//去除PS
					//sb.append(ids[i].substring(2).toUpperCase());
				}
				else {
					sb.append(ids[i].toLowerCase());
					sb.append("/");
				}
			}
			
			sb.append(ids[ids.length -1 ].substring(0,1).toUpperCase() + ids[ids.length -1 ].substring(1));
			return sb.toString();
		}
		else {
			if(iPSModelObject.getParentPSModelObject()!=null){
				//此处代码有问题
				sb.append(this.getFileName(iPSModelObject.getParentPSModelObject(), null));
				sb.append("/");
			}
			sb.append(strId.substring(0,1).toUpperCase() + strId.substring(1));
			return sb.toString();
		}
	}
	
	
}
