/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.codegen.template.rtmodel.dsl;

import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import net.ibizsys.codegen.template.rtmodel.dsl.IModelDSLGenEngineContext;
import net.ibizsys.codegen.template.rtmodel.dsl.IModelWriter;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.PSModelUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

public abstract class ModelWriterBase
implements IModelWriter {
    private static final Log log = LogFactory.getLog(ModelWriterBase.class);
    private static ThreadLocal<Map> KeyMapThreadLocal = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(IModelDSLGenEngineContext iModelDSLGenEngineContext, Writer writer, IPSModelObject iPSModelObject, String indent) throws Exception {
        Map last = KeyMapThreadLocal.get();
        try {
            HashMap keyMap = new HashMap();
            KeyMapThreadLocal.set(keyMap);
            this.onWrite(iModelDSLGenEngineContext, writer, iPSModelObject, indent);
        }
        finally {
            KeyMapThreadLocal.set(last);
        }
    }

    protected void onWrite(IModelDSLGenEngineContext iModelDSLGenEngineContext, Writer writer, IPSModelObject iPSModelObject, String indent) throws Exception {
    }

    @Override
    public void export(IModelDSLGenEngineContext iModelDSLGenEngineContext, IPSModelObject iPSModelObject) throws Exception {
        this.onExport(iModelDSLGenEngineContext, iPSModelObject);
    }

    protected void onExport(IModelDSLGenEngineContext iModelDSLGenEngineContext, IPSModelObject iPSModelObject) throws Exception {
    }

    protected void write(Writer writer, String key, Object value, String defaultValue, String indent) throws Exception {
        Map map = KeyMapThreadLocal.get();
        if (value == null || map.containsKey(key)) {
            return;
        }
        map.put(key, value);
        if (value instanceof IPSModelObject) {
            IPSModelObject iPSModelObject = (IPSModelObject)value;
            String strId = PSModelUtils.calcUniqueTag((IPSModelObject)iPSModelObject);
            if (StringUtils.hasLength((String)strId)) {
                writer.append(indent);
                writer.append(key);
                writer.append(" ");
                writer.append(String.format("'%1$s'", strId));
                writer.append("\n");
            }
            return;
        }
        String strValue = value.toString();
        if (defaultValue.equals(strValue)) {
            return;
        }
        writer.append(indent);
        writer.append(key);
        writer.append(" ");
        if (value instanceof String) {
            if (strValue.indexOf("\n") != -1 || strValue.indexOf("\r") != -1) {
                writer.append(String.format("'''%1$s'''", strValue.replace("\\", "\\\\").replace("'", "\\'")));
            } else {
                writer.append(String.format("'%1$s'", strValue.replace("\\", "\\\\").replace("'", "\\'")));
            }
            writer.append("\n");
            return;
        }
        if (value instanceof BigInteger) {
            writer.append(String.format("new BigInteger('%1$s')", value.toString()));
            writer.append("\n");
            return;
        }
        if (value instanceof BigDecimal) {
            writer.append(String.format("new BigDecimal('%1$s')", value.toString()));
            writer.append("\n");
            return;
        }
        if (value instanceof Double) {
            writer.append(String.format("%1$sd", value.toString()));
            writer.append("\n");
            return;
        }
        writer.append(value.toString());
        writer.append("\n");
    }
}

