package net.ibizsys.codegen.template.rtmodel.dsl.wf;

import java.io.File;
import java.io.Writer;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.codegen.template.rtmodel.dsl.IModelDSLGenEngineContext;

public class WFLinkWriter extends net.ibizsys.codegen.template.rtmodel.dsl.ModelObjectWriter{

	protected void onWrite(IModelDSLGenEngineContext iModelDSLGenEngineContext, Writer writer, IPSModelObject object, String indent) throws Exception{
		
		net.ibizsys.model.wf.IPSWFLink iPSWFLink = (net.ibizsys.model.wf.IPSWFLink)object;
		
		this.write(writer, "customCond", iPSWFLink.getCustomCond(), "", indent);
		this.write(writer, "fromWFProcess", iPSWFLink.getFromPSWFProcess(), null, indent);
		this.write(writer, "lnlanguageRes", iPSWFLink.getLNPSLanguageRes(), "", indent);
		this.write(writer, "logicName", iPSWFLink.getLogicName(), "", indent);
		if(iPSWFLink.getPSWFLinkGroupCond() != null){
			writer.write(indent);
			writer.write("groupCond {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.wf.WFLinkGroupCondWriter.class, writer, iPSWFLink.getPSWFLinkGroupCond(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		this.write(writer, "toWFProcess", iPSWFLink.getToPSWFProcess(), null, indent);
		this.write(writer, "wflinkType", iPSWFLink.getWFLinkType(), "", indent);
		this.write(writer, "enableCustomCond", iPSWFLink.isEnableCustomCond(), "false", indent);

		super.onWrite(iModelDSLGenEngineContext, writer, object, indent);
	}
	protected void onExport(IModelDSLGenEngineContext iModelDSLGenEngineContext, IPSModelObject object) throws Exception{
		
		net.ibizsys.model.wf.IPSWFLink iPSWFLink = (net.ibizsys.model.wf.IPSWFLink)object;
		

		super.onExport(iModelDSLGenEngineContext, object);
	}
}