package net.ibizsys.codegen.template.rtmodel.dsl.service;

import java.io.File;
import java.io.Writer;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.codegen.template.rtmodel.dsl.IModelDSLGenEngineContext;

public class SubSysServiceAPIWriter extends net.ibizsys.codegen.template.rtmodel.dsl.ModelObjectWriter{

	protected void onWrite(IModelDSLGenEngineContext iModelDSLGenEngineContext, Writer writer, IPSModelObject object, String indent) throws Exception{
		
		net.ibizsys.model.service.IPSSubSysServiceAPI iPSSubSysServiceAPI = (net.ibizsys.model.service.IPSSubSysServiceAPI)object;
		
		this.write(writer, "apisource", iPSSubSysServiceAPI.getAPISource(), "", indent);
		this.write(writer, "apitag", iPSSubSysServiceAPI.getAPITag(), "", indent);
		this.write(writer, "apitag2", iPSSubSysServiceAPI.getAPITag2(), "", indent);
		this.write(writer, "apitype", iPSSubSysServiceAPI.getAPIType(), "", indent);
		if(iPSSubSysServiceAPI.getAllPSSubSysServiceAPIDERSs() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.service.IPSSubSysServiceAPI.class, "getAllPSSubSysServiceAPIDERSs", false)){
			writer.write(indent);
			writer.write("derss {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.service.SubSysServiceAPIDERSListWriter.class, writer, iPSSubSysServiceAPI.getAllPSSubSysServiceAPIDERSs(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSSubSysServiceAPI.getAllPSSubSysServiceAPIDEs() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.service.IPSSubSysServiceAPI.class, "getAllPSSubSysServiceAPIDEs", false)){
			writer.write(indent);
			writer.write("des {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.service.SubSysServiceAPIDEListWriter.class, writer, iPSSubSysServiceAPI.getAllPSSubSysServiceAPIDEs(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSSubSysServiceAPI.getAllPSSubSysServiceAPIDTOs() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.service.IPSSubSysServiceAPI.class, "getAllPSSubSysServiceAPIDTOs", false)){
			writer.write(indent);
			writer.write("dtos {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.service.SubSysServiceAPIDTOListWriter.class, writer, iPSSubSysServiceAPI.getAllPSSubSysServiceAPIDTOs(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		this.write(writer, "authAccessTokenUrl", iPSSubSysServiceAPI.getAuthAccessTokenUrl(), "", indent);
		this.write(writer, "authClientId", iPSSubSysServiceAPI.getAuthClientId(), "", indent);
		this.write(writer, "authClientSecret", iPSSubSysServiceAPI.getAuthClientSecret(), "", indent);
		this.write(writer, "authMode", iPSSubSysServiceAPI.getAuthMode(), "", indent);
		this.write(writer, "authParam", iPSSubSysServiceAPI.getAuthParam(), "", indent);
		this.write(writer, "authParam2", iPSSubSysServiceAPI.getAuthParam2(), "", indent);
		this.write(writer, "authParam3", iPSSubSysServiceAPI.getAuthParam3(), "", indent);
		this.write(writer, "authParam4", iPSSubSysServiceAPI.getAuthParam4(), "", indent);
		this.write(writer, "authScriptCode", iPSSubSysServiceAPI.getAuthScriptCode(), "", indent);
		this.write(writer, "authTimeout", iPSSubSysServiceAPI.getAuthTimeout(), "-1", indent);
		this.write(writer, "codeName", iPSSubSysServiceAPI.getCodeName(), "", indent);
		this.write(writer, "handler", iPSSubSysServiceAPI.getHandler(), "", indent);
		this.write(writer, "headerParams", iPSSubSysServiceAPI.getHeaderParams(), "", indent);
		this.write(writer, "methodScriptCode", iPSSubSysServiceAPI.getMethodScriptCode(), "", indent);
		this.write(writer, "openAPI3Schema", iPSSubSysServiceAPI.getPSOpenAPI3Schema(), null, indent);
		this.write(writer, "sysSFPlugin", iPSSubSysServiceAPI.getPSSysSFPlugin(), "", indent);
		this.write(writer, "systemModule", iPSSubSysServiceAPI.getPSSystemModule(), null, indent);
		this.write(writer, "predefinedType", iPSSubSysServiceAPI.getPredefinedType(), "", indent);
		this.write(writer, "serviceCodeName", iPSSubSysServiceAPI.getServiceCodeName(), "", indent);
		this.write(writer, "serviceParam", iPSSubSysServiceAPI.getServiceParam(), "", indent);
		this.write(writer, "serviceParam2", iPSSubSysServiceAPI.getServiceParam2(), "", indent);
		this.write(writer, "serviceParam3", iPSSubSysServiceAPI.getServiceParam3(), "", indent);
		this.write(writer, "serviceParam4", iPSSubSysServiceAPI.getServiceParam4(), "", indent);
		this.write(writer, "servicePath", iPSSubSysServiceAPI.getServicePath(), "", indent);
		this.write(writer, "serviceType", iPSSubSysServiceAPI.getServiceType(), "", indent);
		this.write(writer, "enableServiceAPIDTO", iPSSubSysServiceAPI.isEnableServiceAPIDTO(), "false", indent);

		super.onWrite(iModelDSLGenEngineContext, writer, object, indent);
	}
	protected void onExport(IModelDSLGenEngineContext iModelDSLGenEngineContext, IPSModelObject object) throws Exception{
		
		net.ibizsys.model.service.IPSSubSysServiceAPI iPSSubSysServiceAPI = (net.ibizsys.model.service.IPSSubSysServiceAPI)object;
		
		//默认不导出
		if(iPSSubSysServiceAPI.getAllPSSubSysServiceAPIDERSs() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.service.IPSSubSysServiceAPI.class, "getAllPSSubSysServiceAPIDERSs", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.service.SubSysServiceAPIDERSListWriter.class, iPSSubSysServiceAPI.getAllPSSubSysServiceAPIDERSs());
		}
		//默认不导出
		if(iPSSubSysServiceAPI.getAllPSSubSysServiceAPIDEs() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.service.IPSSubSysServiceAPI.class, "getAllPSSubSysServiceAPIDEs", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.service.SubSysServiceAPIDEListWriter.class, iPSSubSysServiceAPI.getAllPSSubSysServiceAPIDEs());
		}
		//默认不导出
		if(iPSSubSysServiceAPI.getAllPSSubSysServiceAPIDTOs() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.service.IPSSubSysServiceAPI.class, "getAllPSSubSysServiceAPIDTOs", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.service.SubSysServiceAPIDTOListWriter.class, iPSSubSysServiceAPI.getAllPSSubSysServiceAPIDTOs());
		}

		super.onExport(iModelDSLGenEngineContext, object);
	}
}