package net.ibizsys.codegen.template.rtmodel.dsl.res;

import java.io.File;
import java.io.Writer;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.codegen.template.rtmodel.dsl.IModelDSLGenEngineContext;

public class SysContentCatWriter extends net.ibizsys.codegen.template.rtmodel.dsl.ModelObjectWriter{

	protected void onWrite(IModelDSLGenEngineContext iModelDSLGenEngineContext, Writer writer, IPSModelObject object, String indent) throws Exception{
		
		net.ibizsys.model.res.IPSSysContentCat iPSSysContentCat = (net.ibizsys.model.res.IPSSysContentCat)object;
		
		this.write(writer, "catTag", iPSSysContentCat.getCatTag(), "", indent);
		this.write(writer, "catTag2", iPSSysContentCat.getCatTag2(), "", indent);
		this.write(writer, "codeName", iPSSysContentCat.getCodeName(), "", indent);
		if(iPSSysContentCat.getPSSysContents() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.res.IPSSysContentCat.class, "getPSSysContents", false)){
			writer.write(indent);
			writer.write("sysContents {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.res.SysContentListWriter.class, writer, iPSSysContentCat.getPSSysContents(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		this.write(writer, "systemModule", iPSSysContentCat.getPSSystemModule(), null, indent);

		super.onWrite(iModelDSLGenEngineContext, writer, object, indent);
	}
	protected void onExport(IModelDSLGenEngineContext iModelDSLGenEngineContext, IPSModelObject object) throws Exception{
		
		net.ibizsys.model.res.IPSSysContentCat iPSSysContentCat = (net.ibizsys.model.res.IPSSysContentCat)object;
		
		//默认不导出
		if(iPSSysContentCat.getPSSysContents() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.res.IPSSysContentCat.class, "getPSSysContents", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.res.SysContentListWriter.class, iPSSysContentCat.getPSSysContents());
		}

		super.onExport(iModelDSLGenEngineContext, object);
	}
}