package net.ibizsys.codegen.template.rtmodel.dsl.pub;

import java.io.File;
import java.io.Writer;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.codegen.template.rtmodel.dsl.IModelDSLGenEngineContext;

public class SysSFPubWriter extends net.ibizsys.codegen.template.rtmodel.dsl.ModelObjectWriter{

	protected void onWrite(IModelDSLGenEngineContext iModelDSLGenEngineContext, Writer writer, IPSModelObject object, String indent) throws Exception{
		
		net.ibizsys.model.pub.IPSSysSFPub iPSSysSFPub = (net.ibizsys.model.pub.IPSSysSFPub)object;
		
		this.write(writer, "codeName", iPSSysSFPub.getCodeName(), "", indent);
		this.write(writer, "contentType", iPSSysSFPub.getContentType(), "", indent);
		this.write(writer, "defaultFlag", iPSSysSFPub.getDefaultFlag(), "false", indent);
		this.write(writer, "groovySourceFolder", iPSSysSFPub.getGroovySourceFolder(), "", indent);
		this.write(writer, "modelFolder", iPSSysSFPub.getModelFolder(), "", indent);
		this.write(writer, "pkgcodeName", iPSSysSFPub.getPKGCodeName(), "", indent);
		if(iPSSysSFPub.getPSSysSFPubPkgs() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.pub.IPSSysSFPub.class, "getPSSysSFPubPkgs", false)){
			writer.write(indent);
			writer.write("pkgs {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.pub.SysSFPubPkgListWriter.class, writer, iPSSysSFPub.getPSSysSFPubPkgs(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		this.write(writer, "scriptEngine", iPSSysSFPub.getScriptEngine(), "", indent);
		this.write(writer, "versionString", iPSSysSFPub.getVersionString(), "", indent);
		this.write(writer, "codeMode", iPSSysSFPub.isCodeMode(), "false", indent);
		this.write(writer, "docMode", iPSSysSFPub.isDocMode(), "false", indent);
		this.write(writer, "enableModelRT", iPSSysSFPub.isEnableModelRT(), "false", indent);
		this.write(writer, "main", iPSSysSFPub.isMainPSSysSFPub(), "false", indent);
		this.write(writer, "pubModel", iPSSysSFPub.isPubModel(), "false", indent);
		this.write(writer, "subSysPackage", iPSSysSFPub.isSubSysPackage(), "false", indent);
		this.write(writer, "testCodeMode", iPSSysSFPub.isTestCodeMode(), "false", indent);

		super.onWrite(iModelDSLGenEngineContext, writer, object, indent);
	}
	protected void onExport(IModelDSLGenEngineContext iModelDSLGenEngineContext, IPSModelObject object) throws Exception{
		
		net.ibizsys.model.pub.IPSSysSFPub iPSSysSFPub = (net.ibizsys.model.pub.IPSSysSFPub)object;
		
		//默认不导出
		if(iPSSysSFPub.getPSSysSFPubPkgs() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.pub.IPSSysSFPub.class, "getPSSysSFPubPkgs", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.pub.SysSFPubPkgListWriter.class, iPSSysSFPub.getPSSysSFPubPkgs());
		}

		super.onExport(iModelDSLGenEngineContext, object);
	}
}