package net.ibizsys.codegen.template.rtmodel.dsl.eai;

import java.io.File;
import java.io.Writer;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.codegen.template.rtmodel.dsl.IModelDSLGenEngineContext;

public class SysEAISchemeWriter extends net.ibizsys.codegen.template.rtmodel.dsl.ModelObjectWriter{

	protected void onWrite(IModelDSLGenEngineContext iModelDSLGenEngineContext, Writer writer, IPSModelObject object, String indent) throws Exception{
		
		net.ibizsys.model.eai.IPSSysEAIScheme iPSSysEAIScheme = (net.ibizsys.model.eai.IPSSysEAIScheme)object;
		
		if(iPSSysEAIScheme.getAllPSSysEAIDEs() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.eai.IPSSysEAIScheme.class, "getAllPSSysEAIDEs", false)){
			writer.write(indent);
			writer.write("sysEAIDEs {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.eai.SysEAIDEListWriter.class, writer, iPSSysEAIScheme.getAllPSSysEAIDEs(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSSysEAIScheme.getAllPSSysEAIDataTypes() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.eai.IPSSysEAIScheme.class, "getAllPSSysEAIDataTypes", false)){
			writer.write(indent);
			writer.write("sysEAIDataTypes {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.eai.SysEAIDataTypeListWriter.class, writer, iPSSysEAIScheme.getAllPSSysEAIDataTypes(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSSysEAIScheme.getAllPSSysEAIElements() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.eai.IPSSysEAIScheme.class, "getAllPSSysEAIElements", false)){
			writer.write(indent);
			writer.write("sysEAIElements {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.eai.SysEAIElementListWriter.class, writer, iPSSysEAIScheme.getAllPSSysEAIElements(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		this.write(writer, "sysSFPlugin", iPSSysEAIScheme.getPSSysSFPlugin(), "", indent);
		this.write(writer, "systemModule", iPSSysEAIScheme.getPSSystemModule(), null, indent);

		super.onWrite(iModelDSLGenEngineContext, writer, object, indent);
	}
	protected void onExport(IModelDSLGenEngineContext iModelDSLGenEngineContext, IPSModelObject object) throws Exception{
		
		net.ibizsys.model.eai.IPSSysEAIScheme iPSSysEAIScheme = (net.ibizsys.model.eai.IPSSysEAIScheme)object;
		
		//默认不导出
		if(iPSSysEAIScheme.getAllPSSysEAIDEs() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.eai.IPSSysEAIScheme.class, "getAllPSSysEAIDEs", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.eai.SysEAIDEListWriter.class, iPSSysEAIScheme.getAllPSSysEAIDEs());
		}
		//默认不导出
		if(iPSSysEAIScheme.getAllPSSysEAIDataTypes() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.eai.IPSSysEAIScheme.class, "getAllPSSysEAIDataTypes", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.eai.SysEAIDataTypeListWriter.class, iPSSysEAIScheme.getAllPSSysEAIDataTypes());
		}
		//默认不导出
		if(iPSSysEAIScheme.getAllPSSysEAIElements() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.eai.IPSSysEAIScheme.class, "getAllPSSysEAIElements", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.eai.SysEAIElementListWriter.class, iPSSysEAIScheme.getAllPSSysEAIElements());
		}

		super.onExport(iModelDSLGenEngineContext, object);
	}
}