package net.ibizsys.codegen.template.rtmodel.dsl.dynamodel;

import java.io.Writer;
import java.util.List;
import net.ibizsys.codegen.template.rtmodel.dsl.ModelListWriterBase;
import net.ibizsys.codegen.template.rtmodel.dsl.IModelDSLGenEngineContext;

public class SysDynaModelListWriter extends ModelListWriterBase<net.ibizsys.model.dynamodel.IPSSysDynaModel>{
	@Override
	protected void onWrite(IModelDSLGenEngineContext iModelDSLGenEngineContext, Writer writer, List<net.ibizsys.model.dynamodel.IPSSysDynaModel> list, String indent) throws Exception {
		for(net.ibizsys.model.dynamodel.IPSSysDynaModel item : list) {
			if("LIQUIBASECHANGELOG".equals(item.getUsage())){
				writer.write(indent);
				writer.write("liquibasechangelog {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dynamodel.LiquibaseChangeLogModelWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			if("OPENAPI3SCHEMA".equals(item.getUsage())){
				writer.write(indent);
				writer.write("openapi3schema {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dynamodel.OpenAPI3SchemaModelWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			
			writer.write(indent);
			writer.write("item {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dynamodel.SysDynaModelWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		//super.onWrite(writer, list, indent);
	}
	
	@Override
	protected void onExport(IModelDSLGenEngineContext iModelDSLGenEngineContext, List<net.ibizsys.model.dynamodel.IPSSysDynaModel> list) throws Exception {
		for(net.ibizsys.model.dynamodel.IPSSysDynaModel item : list) {
			if("LIQUIBASECHANGELOG".equals(item.getUsage())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dynamodel.LiquibaseChangeLogModelWriter.class, item, "SysDynaModel");
				continue;
			}
			if("OPENAPI3SCHEMA".equals(item.getUsage())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dynamodel.OpenAPI3SchemaModelWriter.class, item, "SysDynaModel");
				continue;
			}
			
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dynamodel.SysDynaModelWriter.class, item, "SysDynaModel");
		}
		//super.onExport(root, list);
	}
	
}