package net.ibizsys.codegen.template.rtmodel.dsl.dataentity.service;

import java.io.File;
import java.io.Writer;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.codegen.template.rtmodel.dsl.IModelDSLGenEngineContext;

public class DEServiceAPIRSWriter extends net.ibizsys.codegen.template.rtmodel.dsl.ModelObjectWriter{

	protected void onWrite(IModelDSLGenEngineContext iModelDSLGenEngineContext, Writer writer, IPSModelObject object, String indent) throws Exception{
		
		net.ibizsys.model.dataentity.service.IPSDEServiceAPIRS iPSDEServiceAPIRS = (net.ibizsys.model.dataentity.service.IPSDEServiceAPIRS)object;
		
		this.write(writer, "codeName", iPSDEServiceAPIRS.getCodeName(), "", indent);
		this.write(writer, "codeName2", iPSDEServiceAPIRS.getCodeName2(), "", indent);
		this.write(writer, "majorDEServiceAPI", iPSDEServiceAPIRS.getMajorPSDEServiceAPI(), null, indent);
		this.write(writer, "minorDEServiceAPI", iPSDEServiceAPIRS.getMinorPSDEServiceAPI(), null, indent);
		this.write(writer, "orderValue", iPSDEServiceAPIRS.getOrderValue(), "99999", indent);
		this.write(writer, "der", iPSDEServiceAPIRS.getPSDER(), null, indent);
		if(iPSDEServiceAPIRS.getPSDEServiceAPIMethods() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.service.IPSDEServiceAPIRS.class, "getPSDEServiceAPIMethods", false)){
			writer.write(indent);
			writer.write("deserviceAPIMethods {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.service.DEServiceAPIMethodListWriter.class, writer, iPSDEServiceAPIRS.getPSDEServiceAPIMethods(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		this.write(writer, "parentFilter", iPSDEServiceAPIRS.getParentFilter(), "", indent);
		this.write(writer, "parentIdDEField", iPSDEServiceAPIRS.getParentIdPSDEField(), null, indent);
		this.write(writer, "parentTypeFilter", iPSDEServiceAPIRS.getParentTypeFilter(), "", indent);
		this.write(writer, "parentTypeDEField", iPSDEServiceAPIRS.getParentTypePSDEField(), null, indent);
		this.write(writer, "array", iPSDEServiceAPIRS.isArray(), "false", indent);
		this.write(writer, "enableDataExport", iPSDEServiceAPIRS.isEnableDataExport(), "false", indent);
		this.write(writer, "enableDataImport", iPSDEServiceAPIRS.isEnableDataImport(), "false", indent);

		super.onWrite(iModelDSLGenEngineContext, writer, object, indent);
	}
	protected void onExport(IModelDSLGenEngineContext iModelDSLGenEngineContext, IPSModelObject object) throws Exception{
		
		net.ibizsys.model.dataentity.service.IPSDEServiceAPIRS iPSDEServiceAPIRS = (net.ibizsys.model.dataentity.service.IPSDEServiceAPIRS)object;
		
		//默认不导出
		if(iPSDEServiceAPIRS.getPSDEServiceAPIMethods() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.service.IPSDEServiceAPIRS.class, "getPSDEServiceAPIMethods", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.service.DEServiceAPIMethodListWriter.class, iPSDEServiceAPIRS.getPSDEServiceAPIMethods());
		}

		super.onExport(iModelDSLGenEngineContext, object);
	}
}