package net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic;

import java.io.File;
import java.io.Writer;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.codegen.template.rtmodel.dsl.IModelDSLGenEngineContext;

public class DEMSLogicNodeWriter extends net.ibizsys.codegen.template.rtmodel.dsl.ModelObjectWriter{

	protected void onWrite(IModelDSLGenEngineContext iModelDSLGenEngineContext, Writer writer, IPSModelObject object, String indent) throws Exception{
		
		net.ibizsys.model.dataentity.logic.IPSDEMSLogicNode iPSDEMSLogicNode = (net.ibizsys.model.dataentity.logic.IPSDEMSLogicNode)object;
		
		this.write(writer, "codeName", iPSDEMSLogicNode.getCodeName(), "", indent);
		this.write(writer, "height", iPSDEMSLogicNode.getHeight(), "0", indent);
		this.write(writer, "leftPos", iPSDEMSLogicNode.getLeftPos(), "0", indent);
		this.write(writer, "logicNodeType", iPSDEMSLogicNode.getLogicNodeType(), "", indent);
		if(iPSDEMSLogicNode.getPSDEMSLogicLinks() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.logic.IPSDEMSLogicNode.class, "getPSDEMSLogicLinks", false)){
			writer.write(indent);
			writer.write("demslogicLinks {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.DEMSLogicLinkListWriter.class, writer, iPSDEMSLogicNode.getPSDEMSLogicLinks(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		this.write(writer, "demainState", iPSDEMSLogicNode.getPSDEMainState(), null, indent);
		this.write(writer, "topPos", iPSDEMSLogicNode.getTopPos(), "0", indent);
		this.write(writer, "width", iPSDEMSLogicNode.getWidth(), "0", indent);
		this.write(writer, "parallelOutput", iPSDEMSLogicNode.isParallelOutput(), "false", indent);

		super.onWrite(iModelDSLGenEngineContext, writer, object, indent);
	}
	protected void onExport(IModelDSLGenEngineContext iModelDSLGenEngineContext, IPSModelObject object) throws Exception{
		
		net.ibizsys.model.dataentity.logic.IPSDEMSLogicNode iPSDEMSLogicNode = (net.ibizsys.model.dataentity.logic.IPSDEMSLogicNode)object;
		
		//默认不导出
		if(iPSDEMSLogicNode.getPSDEMSLogicLinks() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.logic.IPSDEMSLogicNode.class, "getPSDEMSLogicLinks", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.DEMSLogicLinkListWriter.class, iPSDEMSLogicNode.getPSDEMSLogicLinks());
		}

		super.onExport(iModelDSLGenEngineContext, object);
	}
}