package net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic;

import java.io.Writer;
import java.util.List;
import net.ibizsys.codegen.template.rtmodel.dsl.ModelListWriterBase;
import net.ibizsys.codegen.template.rtmodel.dsl.IModelDSLGenEngineContext;

public class DEMSLogicLinkCondListWriter extends ModelListWriterBase<net.ibizsys.model.dataentity.logic.IPSDEMSLogicLinkCond>{
	@Override
	protected void onWrite(IModelDSLGenEngineContext iModelDSLGenEngineContext, Writer writer, List<net.ibizsys.model.dataentity.logic.IPSDEMSLogicLinkCond> list, String indent) throws Exception {
		for(net.ibizsys.model.dataentity.logic.IPSDEMSLogicLinkCond item : list) {
			if("GROUP".equals(item.getLogicType())){
				writer.write(indent);
				writer.write("group {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.DEMSLogicLinkGroupCondWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			if("SINGLE".equals(item.getLogicType())){
				writer.write(indent);
				writer.write("single {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.DEMSLogicLinkSingleCondWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
		}
		//super.onWrite(writer, list, indent);
	}
	
	@Override
	protected void onExport(IModelDSLGenEngineContext iModelDSLGenEngineContext, List<net.ibizsys.model.dataentity.logic.IPSDEMSLogicLinkCond> list) throws Exception {
		for(net.ibizsys.model.dataentity.logic.IPSDEMSLogicLinkCond item : list) {
			if("GROUP".equals(item.getLogicType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.DEMSLogicLinkGroupCondWriter.class, item, "DEMSLogicLinkCond");
				continue;
			}
			if("SINGLE".equals(item.getLogicType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.DEMSLogicLinkSingleCondWriter.class, item, "DEMSLogicLinkCond");
				continue;
			}
		}
		//super.onExport(root, list);
	}
	
}