package net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic;

import java.io.File;
import java.io.Writer;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.codegen.template.rtmodel.dsl.IModelDSLGenEngineContext;

public class DELogicWriter extends net.ibizsys.codegen.template.rtmodel.dsl.dataentity.DataEntityObjectWriter{

	protected void onWrite(IModelDSLGenEngineContext iModelDSLGenEngineContext, Writer writer, IPSModelObject object, String indent) throws Exception{
		
		net.ibizsys.model.dataentity.logic.IPSDELogic iPSDELogic = (net.ibizsys.model.dataentity.logic.IPSDELogic)object;
		
		this.write(writer, "codeName", iPSDELogic.getCodeName(), "", indent);
		this.write(writer, "debugMode", iPSDELogic.getDebugMode(), "0", indent);
		this.write(writer, "defaultParamName", iPSDELogic.getDefaultParamName(), "", indent);
		this.write(writer, "extendMode", iPSDELogic.getExtendMode(), "0", indent);
		this.write(writer, "logicName", iPSDELogic.getLogicName(), "", indent);
		this.write(writer, "logicSubType", iPSDELogic.getLogicSubType(), "NONE", indent);
		if(iPSDELogic.getPSDELogicNodes() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.logic.IPSDELogic.class, "getPSDELogicNodes", false)){
			writer.write(indent);
			writer.write("nodes {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.DELogicNodeListWriter.class, writer, iPSDELogic.getPSDELogicNodes(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSDELogic.getPSDELogicParams() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.logic.IPSDELogic.class, "getPSDELogicParams", false)){
			writer.write(indent);
			writer.write("params {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.DELogicParamListWriter.class, writer, iPSDELogic.getPSDELogicParams(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		this.write(writer, "sysSFPlugin", iPSDELogic.getPSSysSFPlugin(), "", indent);
		this.write(writer, "scriptCode", iPSDELogic.getScriptCode(), "", indent);
		this.write(writer, "startNode", iPSDELogic.getStartPSDELogicNode(), null, indent);
		this.write(writer, "customCode", iPSDELogic.isCustomCode(), "false", indent);
		this.write(writer, "enableBackend", iPSDELogic.isEnableBackend(), "false", indent);
		
		net.ibizsys.model.IPSModelSortable iPSModelSortable = (net.ibizsys.model.IPSModelSortable)object;
		
		this.write(writer, "codeName", iPSModelSortable.getCodeName(), "", indent);
		this.write(writer, "orderValue", iPSModelSortable.getOrderValue(), "0", indent);

		super.onWrite(iModelDSLGenEngineContext, writer, object, indent);
	}
	protected void onExport(IModelDSLGenEngineContext iModelDSLGenEngineContext, IPSModelObject object) throws Exception{
		
		net.ibizsys.model.dataentity.logic.IPSDELogic iPSDELogic = (net.ibizsys.model.dataentity.logic.IPSDELogic)object;
		
		//默认不导出
		if(iPSDELogic.getPSDELogicNodes() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.logic.IPSDELogic.class, "getPSDELogicNodes", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.DELogicNodeListWriter.class, iPSDELogic.getPSDELogicNodes());
		}
		//默认不导出
		if(iPSDELogic.getPSDELogicParams() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.logic.IPSDELogic.class, "getPSDELogicParams", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.DELogicParamListWriter.class, iPSDELogic.getPSDELogicParams());
		}
		
		net.ibizsys.model.IPSModelSortable iPSModelSortable = (net.ibizsys.model.IPSModelSortable)object;
		

		super.onExport(iModelDSLGenEngineContext, object);
	}
}