package net.ibizsys.codegen.template.rtmodel.dsl.dataentity.datamap;

import java.io.File;
import java.io.Writer;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.codegen.template.rtmodel.dsl.IModelDSLGenEngineContext;

public class DEMapWriter extends net.ibizsys.codegen.template.rtmodel.dsl.dataentity.DataEntityObjectWriter{

	protected void onWrite(IModelDSLGenEngineContext iModelDSLGenEngineContext, Writer writer, IPSModelObject object, String indent) throws Exception{
		
		net.ibizsys.model.dataentity.datamap.IPSDEMap iPSDEMap = (net.ibizsys.model.dataentity.datamap.IPSDEMap)object;
		
		this.write(writer, "codeName", iPSDEMap.getCodeName(), "", indent);
		this.write(writer, "dstDE", iPSDEMap.getDstPSDE(), null, indent);
		if(iPSDEMap.getPSDEMapActions() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.datamap.IPSDEMap.class, "getPSDEMapActions", false)){
			writer.write(indent);
			writer.write("actions {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.datamap.DEMapActionListWriter.class, writer, iPSDEMap.getPSDEMapActions(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSDEMap.getPSDEMapDataQueries() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.datamap.IPSDEMap.class, "getPSDEMapDataQueries", false)){
			writer.write(indent);
			writer.write("dataQueries {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.datamap.DEMapDataQueryListWriter.class, writer, iPSDEMap.getPSDEMapDataQueries(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSDEMap.getPSDEMapDataSets() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.datamap.IPSDEMap.class, "getPSDEMapDataSets", false)){
			writer.write(indent);
			writer.write("dataSets {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.datamap.DEMapDataSetListWriter.class, writer, iPSDEMap.getPSDEMapDataSets(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSDEMap.getPSDEMapFields() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.datamap.IPSDEMap.class, "getPSDEMapFields", false)){
			writer.write(indent);
			writer.write("fields {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.datamap.DEMapFieldListWriter.class, writer, iPSDEMap.getPSDEMapFields(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		this.write(writer, "sysSFPlugin", iPSDEMap.getPSSysSFPlugin(), "", indent);
		
		net.ibizsys.model.IPSModelSortable iPSModelSortable = (net.ibizsys.model.IPSModelSortable)object;
		
		this.write(writer, "orderValue", iPSModelSortable.getOrderValue(), "0", indent);

		super.onWrite(iModelDSLGenEngineContext, writer, object, indent);
	}
	protected void onExport(IModelDSLGenEngineContext iModelDSLGenEngineContext, IPSModelObject object) throws Exception{
		
		net.ibizsys.model.dataentity.datamap.IPSDEMap iPSDEMap = (net.ibizsys.model.dataentity.datamap.IPSDEMap)object;
		
		//默认不导出
		if(iPSDEMap.getPSDEMapActions() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.datamap.IPSDEMap.class, "getPSDEMapActions", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.datamap.DEMapActionListWriter.class, iPSDEMap.getPSDEMapActions());
		}
		//默认不导出
		if(iPSDEMap.getPSDEMapDataQueries() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.datamap.IPSDEMap.class, "getPSDEMapDataQueries", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.datamap.DEMapDataQueryListWriter.class, iPSDEMap.getPSDEMapDataQueries());
		}
		//默认不导出
		if(iPSDEMap.getPSDEMapDataSets() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.datamap.IPSDEMap.class, "getPSDEMapDataSets", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.datamap.DEMapDataSetListWriter.class, iPSDEMap.getPSDEMapDataSets());
		}
		//默认不导出
		if(iPSDEMap.getPSDEMapFields() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.datamap.IPSDEMap.class, "getPSDEMapFields", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.datamap.DEMapFieldListWriter.class, iPSDEMap.getPSDEMapFields());
		}
		
		net.ibizsys.model.IPSModelSortable iPSModelSortable = (net.ibizsys.model.IPSModelSortable)object;
		

		super.onExport(iModelDSLGenEngineContext, object);
	}
}