package net.ibizsys.codegen.template.rtmodel.dsl.codelist;

import java.io.File;
import java.io.Writer;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.codegen.template.rtmodel.dsl.IModelDSLGenEngineContext;

public class ThresholdGroupWriter extends net.ibizsys.codegen.template.rtmodel.dsl.ModelObjectWriter{

	protected void onWrite(IModelDSLGenEngineContext iModelDSLGenEngineContext, Writer writer, IPSModelObject object, String indent) throws Exception{
		
		net.ibizsys.model.codelist.IPSThresholdGroup iPSThresholdGroup = (net.ibizsys.model.codelist.IPSThresholdGroup)object;
		
		this.write(writer, "beginValueDEField", iPSThresholdGroup.getBeginValuePSDEField(), null, indent);
		this.write(writer, "codeName", iPSThresholdGroup.getCodeName(), "", indent);
		this.write(writer, "customCond", iPSThresholdGroup.getCustomCond(), "", indent);
		this.write(writer, "dataDEField", iPSThresholdGroup.getDataPSDEField(), null, indent);
		this.write(writer, "endValueDEField", iPSThresholdGroup.getEndValuePSDEField(), null, indent);
		this.write(writer, "iconClsDEField", iPSThresholdGroup.getIconClsPSDEField(), null, indent);
		this.write(writer, "dedataSet", iPSThresholdGroup.getPSDEDataSet(), null, indent);
		this.write(writer, "dataEntity", iPSThresholdGroup.getPSDataEntity(), null, indent);
		if(iPSThresholdGroup.getPSThresholds() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.codelist.IPSThresholdGroup.class, "getPSThresholds", false)){
			writer.write(indent);
			writer.write("thresholds {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.codelist.ThresholdListWriter.class, writer, iPSThresholdGroup.getPSThresholds(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		this.write(writer, "textDEField", iPSThresholdGroup.getTextPSDEField(), null, indent);
		this.write(writer, "thresholdGroupTag", iPSThresholdGroup.getThresholdGroupTag(), "", indent);
		this.write(writer, "thresholdGroupTag2", iPSThresholdGroup.getThresholdGroupTag2(), "", indent);
		this.write(writer, "thresholdGroupType", iPSThresholdGroup.getThresholdGroupType(), "", indent);

		super.onWrite(iModelDSLGenEngineContext, writer, object, indent);
	}
	protected void onExport(IModelDSLGenEngineContext iModelDSLGenEngineContext, IPSModelObject object) throws Exception{
		
		net.ibizsys.model.codelist.IPSThresholdGroup iPSThresholdGroup = (net.ibizsys.model.codelist.IPSThresholdGroup)object;
		
		//默认不导出
		if(iPSThresholdGroup.getPSThresholds() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.codelist.IPSThresholdGroup.class, "getPSThresholds", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.codelist.ThresholdListWriter.class, iPSThresholdGroup.getPSThresholds());
		}

		super.onExport(iModelDSLGenEngineContext, object);
	}
}