package net.ibizsys.codegen.template.rtmodel.dsl.bi;

import java.io.File;
import java.io.Writer;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.codegen.template.rtmodel.dsl.IModelDSLGenEngineContext;

public class SysBISchemeWriter extends net.ibizsys.codegen.template.rtmodel.dsl.ModelObjectWriter{

	protected void onWrite(IModelDSLGenEngineContext iModelDSLGenEngineContext, Writer writer, IPSModelObject object, String indent) throws Exception{
		
		net.ibizsys.model.bi.IPSSysBIScheme iPSSysBIScheme = (net.ibizsys.model.bi.IPSSysBIScheme)object;
		
		if(iPSSysBIScheme.getAllPSSysBIAggTables() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.bi.IPSSysBIScheme.class, "getAllPSSysBIAggTables", false)){
			writer.write(indent);
			writer.write("sysBIAggTables {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.bi.SysBIAggTableListWriter.class, writer, iPSSysBIScheme.getAllPSSysBIAggTables(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSSysBIScheme.getAllPSSysBICubes() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.bi.IPSSysBIScheme.class, "getAllPSSysBICubes", false)){
			writer.write(indent);
			writer.write("sysBICubes {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.bi.SysBICubeListWriter.class, writer, iPSSysBIScheme.getAllPSSysBICubes(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSSysBIScheme.getAllPSSysBIDimensions() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.bi.IPSSysBIScheme.class, "getAllPSSysBIDimensions", false)){
			writer.write(indent);
			writer.write("sysBIDimensions {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.bi.SysBIDimensionListWriter.class, writer, iPSSysBIScheme.getAllPSSysBIDimensions(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		this.write(writer, "sysSFPlugin", iPSSysBIScheme.getPSSysSFPlugin(), "", indent);
		this.write(writer, "systemModule", iPSSysBIScheme.getPSSystemModule(), null, indent);

		super.onWrite(iModelDSLGenEngineContext, writer, object, indent);
	}
	protected void onExport(IModelDSLGenEngineContext iModelDSLGenEngineContext, IPSModelObject object) throws Exception{
		
		net.ibizsys.model.bi.IPSSysBIScheme iPSSysBIScheme = (net.ibizsys.model.bi.IPSSysBIScheme)object;
		
		//默认不导出
		if(iPSSysBIScheme.getAllPSSysBIAggTables() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.bi.IPSSysBIScheme.class, "getAllPSSysBIAggTables", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.bi.SysBIAggTableListWriter.class, iPSSysBIScheme.getAllPSSysBIAggTables());
		}
		//默认不导出
		if(iPSSysBIScheme.getAllPSSysBICubes() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.bi.IPSSysBIScheme.class, "getAllPSSysBICubes", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.bi.SysBICubeListWriter.class, iPSSysBIScheme.getAllPSSysBICubes());
		}
		//默认不导出
		if(iPSSysBIScheme.getAllPSSysBIDimensions() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.bi.IPSSysBIScheme.class, "getAllPSSysBIDimensions", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.bi.SysBIDimensionListWriter.class, iPSSysBIScheme.getAllPSSysBIDimensions());
		}

		super.onExport(iModelDSLGenEngineContext, object);
	}
}