package net.ibizsys.codegen.template.rtmodel.dsl;

import java.io.File;
import java.io.Writer;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.codegen.template.rtmodel.dsl.IModelDSLGenEngineContext;

public class SystemWriter extends net.ibizsys.codegen.template.rtmodel.dsl.ModelObjectWriter{

	protected void onWrite(IModelDSLGenEngineContext iModelDSLGenEngineContext, Writer writer, IPSModelObject object, String indent) throws Exception{
		
		net.ibizsys.model.IPSSystem iPSSystem = (net.ibizsys.model.IPSSystem)object;
		
		//默认导出文件
		if(iPSSystem.getAllPSCodeLists() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSCodeLists", true)){
			writer.write(indent);
			writer.write("codeLists {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.codelist.CodeListListWriter.class, writer, iPSSystem.getAllPSCodeLists(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSSystem.getAllPSDEOPPrivs() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSDEOPPrivs", false)){
			writer.write(indent);
			writer.write("deopprivs {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.priv.SysDEOPPrivListWriter.class, writer, iPSSystem.getAllPSDEOPPrivs(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		//默认导出文件
		if(iPSSystem.getAllPSDataEntities() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSDataEntities", true)){
			writer.write(indent);
			writer.write("dataEntities {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.DataEntityListWriter.class, writer, iPSSystem.getAllPSDataEntities(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		//默认导出文件
		if(iPSSystem.getAllPSSubSysServiceAPIs() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSubSysServiceAPIs", true)){
			writer.write(indent);
			writer.write("subSysServiceAPIs {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.service.SubSysServiceAPIListWriter.class, writer, iPSSystem.getAllPSSubSysServiceAPIs(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		//默认导出文件
		if(iPSSystem.getAllPSSysBDSchemes() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysBDSchemes", true)){
			writer.write(indent);
			writer.write("bdschemes {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.ba.SysBDSchemeListWriter.class, writer, iPSSystem.getAllPSSysBDSchemes(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		//默认导出文件
		if(iPSSystem.getAllPSSysBISchemes() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysBISchemes", true)){
			writer.write(indent);
			writer.write("bischemes {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.bi.SysBISchemeListWriter.class, writer, iPSSystem.getAllPSSysBISchemes(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		//默认导出文件
		if(iPSSystem.getAllPSSysBackServices() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysBackServices", true)){
			writer.write(indent);
			writer.write("backServices {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.backservice.SysBackServiceListWriter.class, writer, iPSSystem.getAllPSSysBackServices(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		//默认导出文件
		if(iPSSystem.getAllPSSysContentCats() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysContentCats", true)){
			writer.write(indent);
			writer.write("contentCats {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.res.SysContentCatListWriter.class, writer, iPSSystem.getAllPSSysContentCats(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		//默认导出文件
		if(iPSSystem.getAllPSSysDBSchemes() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysDBSchemes", true)){
			writer.write(indent);
			writer.write("dbschemes {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.database.SysDBSchemeListWriter.class, writer, iPSSystem.getAllPSSysDBSchemes(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		//默认导出文件
		if(iPSSystem.getAllPSSysDBValueFuncs() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysDBValueFuncs", true)){
			writer.write(indent);
			writer.write("dbvalueFuncs {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.database.SysDBValueFuncListWriter.class, writer, iPSSystem.getAllPSSysDBValueFuncs(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSSystem.getAllPSSysDEGroups() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysDEGroups", false)){
			writer.write(indent);
			writer.write("degroups {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.SysDEGroupListWriter.class, writer, iPSSystem.getAllPSSysDEGroups(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		//默认导出文件
		if(iPSSystem.getAllPSSysDERGroups() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysDERGroups", true)){
			writer.write(indent);
			writer.write("dergroups {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.der.SysDERGroupListWriter.class, writer, iPSSystem.getAllPSSysDERGroups(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSSystem.getAllPSSysDTSQueues() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysDTSQueues", false)){
			writer.write(indent);
			writer.write("dtsqueues {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dts.SysDTSQueueListWriter.class, writer, iPSSystem.getAllPSSysDTSQueues(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSSystem.getAllPSSysDataSyncAgents() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysDataSyncAgents", false)){
			writer.write(indent);
			writer.write("dataSyncAgents {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.res.SysDataSyncAgentListWriter.class, writer, iPSSystem.getAllPSSysDataSyncAgents(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		//默认导出文件
		if(iPSSystem.getAllPSSysDynaModels() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysDynaModels", true)){
			writer.write(indent);
			writer.write("dynaModels {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dynamodel.SysDynaModelListWriter.class, writer, iPSSystem.getAllPSSysDynaModels(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		//默认导出文件
		if(iPSSystem.getAllPSSysI18Ns() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysI18Ns", true)){
			writer.write(indent);
			writer.write("i18Ns {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.res.SysI18NListWriter.class, writer, iPSSystem.getAllPSSysI18Ns(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSSystem.getAllPSSysLogics() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysLogics", false)){
			writer.write(indent);
			writer.write("logics {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.res.SysLogicListWriter.class, writer, iPSSystem.getAllPSSysLogics(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSSystem.getAllPSSysMethodDTOs() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysMethodDTOs", false)){
			writer.write(indent);
			writer.write("methodDTOs {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.service.SysMethodDTOListWriter.class, writer, iPSSystem.getAllPSSysMethodDTOs(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSSystem.getAllPSSysModelGroups() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysModelGroups", false)){
			writer.write(indent);
			writer.write("modelGroups {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.system.SysModelGroupListWriter.class, writer, iPSSystem.getAllPSSysModelGroups(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSSystem.getAllPSSysMsgQueues() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysMsgQueues", false)){
			writer.write(indent);
			writer.write("msgQueues {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.msg.SysMsgQueueListWriter.class, writer, iPSSystem.getAllPSSysMsgQueues(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSSystem.getAllPSSysMsgTargets() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysMsgTargets", false)){
			writer.write(indent);
			writer.write("msgTargets {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.msg.SysMsgTargetListWriter.class, writer, iPSSystem.getAllPSSysMsgTargets(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSSystem.getAllPSSysMsgTempls() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysMsgTempls", false)){
			writer.write(indent);
			writer.write("msgTempls {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.msg.SysMsgTemplListWriter.class, writer, iPSSystem.getAllPSSysMsgTempls(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSSystem.getAllPSSysRefs() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysRefs", false)){
			writer.write(indent);
			writer.write("sysRefs {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.system.SysRefListWriter.class, writer, iPSSystem.getAllPSSysRefs(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSSystem.getAllPSSysResources() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysResources", false)){
			writer.write(indent);
			writer.write("resources {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.res.SysResourceListWriter.class, writer, iPSSystem.getAllPSSysResources(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSSystem.getAllPSSysSFPlugins() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysSFPlugins", false)){
			writer.write(indent);
			writer.write("sfplugins {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.res.SysSFPluginListWriter.class, writer, iPSSystem.getAllPSSysSFPlugins(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		//默认导出文件
		if(iPSSystem.getAllPSSysSFPubs() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysSFPubs", true)){
			writer.write(indent);
			writer.write("sfpubs {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.pub.SysSFPubListWriter.class, writer, iPSSystem.getAllPSSysSFPubs(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		//默认导出文件
		if(iPSSystem.getAllPSSysSampleValues() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysSampleValues", true)){
			writer.write(indent);
			writer.write("sampleValues {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.res.SysSampleValueListWriter.class, writer, iPSSystem.getAllPSSysSampleValues(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		//默认导出文件
		if(iPSSystem.getAllPSSysSearchSchemes() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysSearchSchemes", true)){
			writer.write(indent);
			writer.write("searchSchemes {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.search.SysSearchSchemeListWriter.class, writer, iPSSystem.getAllPSSysSearchSchemes(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		//默认导出文件
		if(iPSSystem.getAllPSSysSequences() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysSequences", true)){
			writer.write(indent);
			writer.write("sequences {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.res.SysSequenceListWriter.class, writer, iPSSystem.getAllPSSysSequences(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		//默认导出文件
		if(iPSSystem.getAllPSSysServiceAPIs() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysServiceAPIs", true)){
			writer.write(indent);
			writer.write("serviceAPIs {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.service.SysServiceAPIListWriter.class, writer, iPSSystem.getAllPSSysServiceAPIs(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		//默认导出文件
		if(iPSSystem.getAllPSSysTestDatas() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysTestDatas", true)){
			writer.write(indent);
			writer.write("testDatas {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.testing.SysTestDataListWriter.class, writer, iPSSystem.getAllPSSysTestDatas(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		//默认导出文件
		if(iPSSystem.getAllPSSysTestPrjs() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysTestPrjs", true)){
			writer.write(indent);
			writer.write("testPrjs {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.testing.SysTestPrjListWriter.class, writer, iPSSystem.getAllPSSysTestPrjs(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		//默认导出文件
		if(iPSSystem.getAllPSSysTranslators() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysTranslators", true)){
			writer.write(indent);
			writer.write("translators {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.res.SysTranslatorListWriter.class, writer, iPSSystem.getAllPSSysTranslators(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSSystem.getAllPSSysUniReses() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysUniReses", false)){
			writer.write(indent);
			writer.write("uniReses {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.security.SysUniResListWriter.class, writer, iPSSystem.getAllPSSysUniReses(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSSystem.getAllPSSysUniStates() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysUniStates", false)){
			writer.write(indent);
			writer.write("uniStates {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.res.SysUniStateListWriter.class, writer, iPSSystem.getAllPSSysUniStates(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSSystem.getAllPSSysUserDRs() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysUserDRs", false)){
			writer.write(indent);
			writer.write("userDRs {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.security.SysUserDRListWriter.class, writer, iPSSystem.getAllPSSysUserDRs(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSSystem.getAllPSSysUserModes() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysUserModes", false)){
			writer.write(indent);
			writer.write("userModes {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.security.SysUserModeListWriter.class, writer, iPSSystem.getAllPSSysUserModes(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSSystem.getAllPSSysUserRoles() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysUserRoles", false)){
			writer.write(indent);
			writer.write("userRoles {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.security.SysUserRoleListWriter.class, writer, iPSSystem.getAllPSSysUserRoles(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSSystem.getAllPSSysUtils() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysUtils", false)){
			writer.write(indent);
			writer.write("utils {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.res.SysUtilListWriter.class, writer, iPSSystem.getAllPSSysUtils(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		//默认导出文件
		if(iPSSystem.getAllPSSysValueRules() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysValueRules", true)){
			writer.write(indent);
			writer.write("valueRules {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.valuerule.SysValueRuleListWriter.class, writer, iPSSystem.getAllPSSysValueRules(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSSystem.getAllPSSystemModules() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSystemModules", false)){
			writer.write(indent);
			writer.write("modules {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.system.SystemModuleListWriter.class, writer, iPSSystem.getAllPSSystemModules(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		//默认导出文件
		if(iPSSystem.getAllPSWFRoles() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSWFRoles", true)){
			writer.write(indent);
			writer.write("wfroles {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.wf.WFRoleListWriter.class, writer, iPSSystem.getAllPSWFRoles(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		//默认导出文件
		if(iPSSystem.getAllPSWFWorkTimes() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSWFWorkTimes", true)){
			writer.write(indent);
			writer.write("wfworkTimes {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.wf.WFWorkTimeListWriter.class, writer, iPSSystem.getAllPSWFWorkTimes(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		//默认导出文件
		if(iPSSystem.getAllPSWorkflows() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSWorkflows", true)){
			writer.write(indent);
			writer.write("workflows {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.wf.WorkflowListWriter.class, writer, iPSSystem.getAllPSWorkflows(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		this.write(writer, "codeName", iPSSystem.getCodeName(), "", indent);
		this.write(writer, "defaultLanguage", iPSSystem.getDefaultLanguage(), "", indent);
		this.write(writer, "defaultI18N", iPSSystem.getDefaultPSSysI18N(), null, indent);
		this.write(writer, "deploySysId", iPSSystem.getDeploySysId(), "", indent);
		this.write(writer, "deploySysOrgId", iPSSystem.getDeploySysOrgId(), "", indent);
		this.write(writer, "deploySysOrgSectorId", iPSSystem.getDeploySysOrgSectorId(), "", indent);
		this.write(writer, "deploySysTag", iPSSystem.getDeploySysTag(), "", indent);
		this.write(writer, "deploySysTag2", iPSSystem.getDeploySysTag2(), "", indent);
		this.write(writer, "deploySysType", iPSSystem.getDeploySysType(), "", indent);
		this.write(writer, "engineVer", iPSSystem.getEngineVer(), "0", indent);
		if(iPSSystem.getInitPSSysContents() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getInitPSSysContents", false)){
			writer.write(indent);
			writer.write("initContents {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.res.SysContentListWriter.class, writer, iPSSystem.getInitPSSysContents(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		this.write(writer, "logicName", iPSSystem.getLogicName(), "", indent);
		this.write(writer, "rtobjectName", iPSSystem.getRTObjectName(), "", indent);
		if(iPSSystem.getSamplePSSysContents() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getSamplePSSysContents", false)){
			writer.write(indent);
			writer.write("sampleContents {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.res.SysContentListWriter.class, writer, iPSSystem.getSamplePSSysContents(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		this.write(writer, "sysTag", iPSSystem.getSysTag(), "", indent);
		this.write(writer, "sysTag2", iPSSystem.getSysTag2(), "", indent);
		this.write(writer, "sysTag3", iPSSystem.getSysTag3(), "", indent);
		this.write(writer, "sysTag4", iPSSystem.getSysTag4(), "", indent);
		this.write(writer, "sysType", iPSSystem.getSysType(), "DEVSYS", indent);
		if(iPSSystem.getTestPSSysContents() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getTestPSSysContents", false)){
			writer.write(indent);
			writer.write("testContents {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.res.SysContentListWriter.class, writer, iPSSystem.getTestPSSysContents(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		this.write(writer, "vcname", iPSSystem.getVCName(), "", indent);

		super.onWrite(iModelDSLGenEngineContext, writer, object, indent);
	}
	protected void onExport(IModelDSLGenEngineContext iModelDSLGenEngineContext, IPSModelObject object) throws Exception{
		
		net.ibizsys.model.IPSSystem iPSSystem = (net.ibizsys.model.IPSSystem)object;
		
		if(iPSSystem.getAllPSCodeLists() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSCodeLists", true)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.codelist.CodeListListWriter.class, iPSSystem.getAllPSCodeLists());
		}
		//默认不导出
		if(iPSSystem.getAllPSDEOPPrivs() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSDEOPPrivs", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.priv.SysDEOPPrivListWriter.class, iPSSystem.getAllPSDEOPPrivs());
		}
		if(iPSSystem.getAllPSDataEntities() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSDataEntities", true)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.DataEntityListWriter.class, iPSSystem.getAllPSDataEntities());
		}
		if(iPSSystem.getAllPSSubSysServiceAPIs() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSubSysServiceAPIs", true)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.service.SubSysServiceAPIListWriter.class, iPSSystem.getAllPSSubSysServiceAPIs());
		}
		if(iPSSystem.getAllPSSysBDSchemes() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysBDSchemes", true)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.ba.SysBDSchemeListWriter.class, iPSSystem.getAllPSSysBDSchemes());
		}
		if(iPSSystem.getAllPSSysBISchemes() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysBISchemes", true)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.bi.SysBISchemeListWriter.class, iPSSystem.getAllPSSysBISchemes());
		}
		if(iPSSystem.getAllPSSysBackServices() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysBackServices", true)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.backservice.SysBackServiceListWriter.class, iPSSystem.getAllPSSysBackServices());
		}
		if(iPSSystem.getAllPSSysContentCats() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysContentCats", true)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.res.SysContentCatListWriter.class, iPSSystem.getAllPSSysContentCats());
		}
		if(iPSSystem.getAllPSSysDBSchemes() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysDBSchemes", true)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.database.SysDBSchemeListWriter.class, iPSSystem.getAllPSSysDBSchemes());
		}
		if(iPSSystem.getAllPSSysDBValueFuncs() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysDBValueFuncs", true)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.database.SysDBValueFuncListWriter.class, iPSSystem.getAllPSSysDBValueFuncs());
		}
		//默认不导出
		if(iPSSystem.getAllPSSysDEGroups() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysDEGroups", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.SysDEGroupListWriter.class, iPSSystem.getAllPSSysDEGroups());
		}
		if(iPSSystem.getAllPSSysDERGroups() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysDERGroups", true)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.der.SysDERGroupListWriter.class, iPSSystem.getAllPSSysDERGroups());
		}
		//默认不导出
		if(iPSSystem.getAllPSSysDTSQueues() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysDTSQueues", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dts.SysDTSQueueListWriter.class, iPSSystem.getAllPSSysDTSQueues());
		}
		//默认不导出
		if(iPSSystem.getAllPSSysDataSyncAgents() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysDataSyncAgents", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.res.SysDataSyncAgentListWriter.class, iPSSystem.getAllPSSysDataSyncAgents());
		}
		if(iPSSystem.getAllPSSysDynaModels() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysDynaModels", true)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dynamodel.SysDynaModelListWriter.class, iPSSystem.getAllPSSysDynaModels());
		}
		if(iPSSystem.getAllPSSysI18Ns() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysI18Ns", true)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.res.SysI18NListWriter.class, iPSSystem.getAllPSSysI18Ns());
		}
		//默认不导出
		if(iPSSystem.getAllPSSysLogics() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysLogics", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.res.SysLogicListWriter.class, iPSSystem.getAllPSSysLogics());
		}
		//默认不导出
		if(iPSSystem.getAllPSSysMethodDTOs() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysMethodDTOs", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.service.SysMethodDTOListWriter.class, iPSSystem.getAllPSSysMethodDTOs());
		}
		//默认不导出
		if(iPSSystem.getAllPSSysModelGroups() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysModelGroups", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.system.SysModelGroupListWriter.class, iPSSystem.getAllPSSysModelGroups());
		}
		//默认不导出
		if(iPSSystem.getAllPSSysMsgQueues() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysMsgQueues", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.msg.SysMsgQueueListWriter.class, iPSSystem.getAllPSSysMsgQueues());
		}
		//默认不导出
		if(iPSSystem.getAllPSSysMsgTargets() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysMsgTargets", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.msg.SysMsgTargetListWriter.class, iPSSystem.getAllPSSysMsgTargets());
		}
		//默认不导出
		if(iPSSystem.getAllPSSysMsgTempls() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysMsgTempls", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.msg.SysMsgTemplListWriter.class, iPSSystem.getAllPSSysMsgTempls());
		}
		//默认不导出
		if(iPSSystem.getAllPSSysRefs() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysRefs", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.system.SysRefListWriter.class, iPSSystem.getAllPSSysRefs());
		}
		//默认不导出
		if(iPSSystem.getAllPSSysResources() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysResources", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.res.SysResourceListWriter.class, iPSSystem.getAllPSSysResources());
		}
		//默认不导出
		if(iPSSystem.getAllPSSysSFPlugins() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysSFPlugins", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.res.SysSFPluginListWriter.class, iPSSystem.getAllPSSysSFPlugins());
		}
		if(iPSSystem.getAllPSSysSFPubs() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysSFPubs", true)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.pub.SysSFPubListWriter.class, iPSSystem.getAllPSSysSFPubs());
		}
		if(iPSSystem.getAllPSSysSampleValues() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysSampleValues", true)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.res.SysSampleValueListWriter.class, iPSSystem.getAllPSSysSampleValues());
		}
		if(iPSSystem.getAllPSSysSearchSchemes() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysSearchSchemes", true)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.search.SysSearchSchemeListWriter.class, iPSSystem.getAllPSSysSearchSchemes());
		}
		if(iPSSystem.getAllPSSysSequences() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysSequences", true)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.res.SysSequenceListWriter.class, iPSSystem.getAllPSSysSequences());
		}
		if(iPSSystem.getAllPSSysServiceAPIs() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysServiceAPIs", true)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.service.SysServiceAPIListWriter.class, iPSSystem.getAllPSSysServiceAPIs());
		}
		if(iPSSystem.getAllPSSysTestDatas() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysTestDatas", true)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.testing.SysTestDataListWriter.class, iPSSystem.getAllPSSysTestDatas());
		}
		if(iPSSystem.getAllPSSysTestPrjs() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysTestPrjs", true)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.testing.SysTestPrjListWriter.class, iPSSystem.getAllPSSysTestPrjs());
		}
		if(iPSSystem.getAllPSSysTranslators() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysTranslators", true)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.res.SysTranslatorListWriter.class, iPSSystem.getAllPSSysTranslators());
		}
		//默认不导出
		if(iPSSystem.getAllPSSysUniReses() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysUniReses", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.security.SysUniResListWriter.class, iPSSystem.getAllPSSysUniReses());
		}
		//默认不导出
		if(iPSSystem.getAllPSSysUniStates() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysUniStates", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.res.SysUniStateListWriter.class, iPSSystem.getAllPSSysUniStates());
		}
		//默认不导出
		if(iPSSystem.getAllPSSysUserDRs() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysUserDRs", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.security.SysUserDRListWriter.class, iPSSystem.getAllPSSysUserDRs());
		}
		//默认不导出
		if(iPSSystem.getAllPSSysUserModes() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysUserModes", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.security.SysUserModeListWriter.class, iPSSystem.getAllPSSysUserModes());
		}
		//默认不导出
		if(iPSSystem.getAllPSSysUserRoles() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysUserRoles", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.security.SysUserRoleListWriter.class, iPSSystem.getAllPSSysUserRoles());
		}
		//默认不导出
		if(iPSSystem.getAllPSSysUtils() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysUtils", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.res.SysUtilListWriter.class, iPSSystem.getAllPSSysUtils());
		}
		if(iPSSystem.getAllPSSysValueRules() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSysValueRules", true)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.valuerule.SysValueRuleListWriter.class, iPSSystem.getAllPSSysValueRules());
		}
		//默认不导出
		if(iPSSystem.getAllPSSystemModules() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSSystemModules", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.system.SystemModuleListWriter.class, iPSSystem.getAllPSSystemModules());
		}
		if(iPSSystem.getAllPSWFRoles() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSWFRoles", true)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.wf.WFRoleListWriter.class, iPSSystem.getAllPSWFRoles());
		}
		if(iPSSystem.getAllPSWFWorkTimes() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSWFWorkTimes", true)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.wf.WFWorkTimeListWriter.class, iPSSystem.getAllPSWFWorkTimes());
		}
		if(iPSSystem.getAllPSWorkflows() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getAllPSWorkflows", true)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.wf.WorkflowListWriter.class, iPSSystem.getAllPSWorkflows());
		}
		//默认不导出
		if(iPSSystem.getInitPSSysContents() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getInitPSSysContents", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.res.SysContentListWriter.class, iPSSystem.getInitPSSysContents());
		}
		//默认不导出
		if(iPSSystem.getSamplePSSysContents() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getSamplePSSysContents", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.res.SysContentListWriter.class, iPSSystem.getSamplePSSysContents());
		}
		//默认不导出
		if(iPSSystem.getTestPSSysContents() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.IPSSystem.class, "getTestPSSysContents", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.res.SysContentListWriter.class, iPSSystem.getTestPSSysContents());
		}

		super.onExport(iModelDSLGenEngineContext, object);
	}
}