/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.codegen.template.rtmodel.dsl;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ibizsys.codegen.template.rtmodel.dsl.IModelDSLGenEngineContext;
import net.ibizsys.codegen.template.rtmodel.dsl.IModelListWriter;
import net.ibizsys.codegen.template.rtmodel.dsl.IModelWriter;
import net.ibizsys.codegen.template.rtmodel.dsl.SystemWriter;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.IPSSystem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

public class ModelDSLGenEngine {
    private static final Log log = LogFactory.getLog(ModelDSLGenEngine.class);
    private String indent = "    ";
    private Map<Class<?>, IModelListWriter<?>> modelListWriterMap = new HashMap();
    private Map<Class<?>, IModelWriter> modelWriterMap = new HashMap();
    private File rootFolder = null;
    private IModelDSLGenEngineContext iModelDSLGenEngineContext = new IModelDSLGenEngineContext(){

        @Override
        public String getIndent() {
            return ModelDSLGenEngine.this.getSelf().getIndent();
        }

        @Override
        public boolean isExportModelFile(Class<?> modelCls, String modelProperty, boolean def) {
            return ModelDSLGenEngine.this.getSelf().isExportModelFile(modelCls, modelProperty, def);
        }

        @Override
        public void write(Class<?> writerCls, Writer writer, List list, String indent) throws Exception {
            ModelDSLGenEngine.this.getSelf().write(writerCls, writer, list, indent);
        }

        @Override
        public void export(Class<?> writerCls, List list) throws Exception {
            ModelDSLGenEngine.this.getSelf().export(writerCls, list);
        }

        @Override
        public void write(Class<?> writerCls, Writer writer, IPSModelObject iPSModelObject, String indent) throws Exception {
            ModelDSLGenEngine.this.getSelf().write(writerCls, writer, iPSModelObject, indent);
        }

        @Override
        public void export(Class<?> writerCls, IPSModelObject iPSModelObject, String defaultType) throws Exception {
            ModelDSLGenEngine.this.getSelf().export(writerCls, iPSModelObject, defaultType);
        }
    };

    protected IModelDSLGenEngineContext getModelDSLGenEngineContext() {
        return this.iModelDSLGenEngineContext;
    }

    private ModelDSLGenEngine getSelf() {
        return this;
    }

    public ModelDSLGenEngine(File rootFolder) {
        this.rootFolder = rootFolder;
    }

    public File getRootFolder() {
        return this.rootFolder;
    }

    public IModelListWriter<?> getModelListWriter(Class<?> cls) throws Exception {
        IModelListWriter modelListWriter = this.modelListWriterMap.get(cls);
        if (modelListWriter == null) {
            modelListWriter = (IModelListWriter)cls.newInstance();
            this.modelListWriterMap.put(cls, modelListWriter);
        }
        return modelListWriter;
    }

    public IModelWriter getModelWriter(Class<?> cls) throws Exception {
        IModelWriter modelWriter = this.modelWriterMap.get(cls);
        if (modelWriter == null) {
            modelWriter = (IModelWriter)cls.newInstance();
            this.modelWriterMap.put(cls, modelWriter);
        }
        return modelWriter;
    }

    public void setModelListWriter(Class<?> cls, IModelListWriter<?> modelListWriter) {
        this.modelListWriterMap.put(cls, modelListWriter);
    }

    public void setModelWriter(Class<?> cls, IModelWriter modelLWriter) {
        this.modelWriterMap.put(cls, modelLWriter);
    }

    public String getIndent() {
        return this.indent;
    }

    public void setIndent(String indent) {
        this.indent = indent;
    }

    protected boolean isExportModelFile(Class<?> modelCls, String modelProperty, boolean def) {
        return def;
    }

    protected void write(Class<?> writerCls, Writer writer, List<?> list, String indent) throws Exception {
        IModelListWriter<?> iModelListWriter = this.getModelListWriter(writerCls);
        iModelListWriter.write(this.getModelDSLGenEngineContext(), writer, list, indent);
    }

    protected void export(Class<?> writerCls, List<?> list) throws Exception {
        IModelListWriter<?> iModelListWriter = this.getModelListWriter(writerCls);
        iModelListWriter.export(this.getModelDSLGenEngineContext(), list);
    }

    protected void write(Class<?> writerCls, Writer writer, IPSModelObject iPSModelObject, String indent) throws Exception {
        IModelWriter iModelWriter = this.getModelWriter(writerCls);
        iModelWriter.write(this.getModelDSLGenEngineContext(), writer, iPSModelObject, indent);
    }

    public void export(IPSSystem iPSSystem) throws Exception {
        this.export(SystemWriter.class, (IPSModelObject)iPSSystem, null);
    }

    public void export(Class<?> writerCls, IPSModelObject iPSModelObject, String defaultType) throws Exception {
        IModelWriter iModelWriter = this.getModelWriter(writerCls);
        String modelFile = this.getFileName(iPSModelObject, defaultType);
        File file = null;
        file = StringUtils.hasLength((String)defaultType) ? new File(this.getRootFolder().getCanonicalPath() + File.separator + defaultType.toLowerCase() + File.separator + modelFile + ".groovy") : new File(this.getRootFolder().getCanonicalPath() + File.separator + modelFile + ".groovy");
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        iModelWriter.export(this.getModelDSLGenEngineContext(), iPSModelObject);
        try (FileWriter fileWriter = new FileWriter(file);){
            iModelWriter.write(this.iModelDSLGenEngineContext, fileWriter, iPSModelObject, "");
        }
    }

    protected String getFileName(IPSModelObject iPSModelObject, String defaultType) throws Exception {
        String strId = iPSModelObject.getId();
        if (!StringUtils.hasLength((String)strId)) {
            throw new Exception(String.format("\u6a21\u578b[%1$s]\u672a\u6307\u5b9a\u6807\u8bc6", iPSModelObject.getName()));
        }
        int nPos = strId.indexOf(".json");
        if (nPos != -1 && nPos == strId.length() - 5) {
            strId = strId.substring(0, strId.length() - 5);
        }
        if (!StringUtils.hasLength((String)strId)) {
            throw new Exception(String.format("\u6a21\u578b[%1$s]\u672a\u6307\u5b9a\u6807\u8bc6", iPSModelObject.getName()));
        }
        StringBuilder sb = new StringBuilder();
        String[] ids = strId.split("[/]");
        if (ids.length > 1) {
            for (int i = 0; i < ids.length - 1; ++i) {
                if (i % 2 == 0) continue;
                sb.append(ids[i].toLowerCase());
                sb.append("/");
            }
            sb.append(ids[ids.length - 1].substring(0, 1).toUpperCase() + ids[ids.length - 1].substring(1));
            return sb.toString();
        }
        if (iPSModelObject.getParentPSModelObject() != null) {
            sb.append(this.getFileName((IPSModelObject)iPSModelObject.getParentPSModelObject(), null));
            sb.append("/");
        }
        sb.append(strId.substring(0, 1).toUpperCase() + strId.substring(1));
        return sb.toString();
    }
}

